/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoCentroidAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Long count;
    @Nullable
    private final JsonValue location;
    public static final JsonpDeserializer<GeoCentroidAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoCentroidAggregation::setupGeoCentroidAggregationDeserializer, Builder::build);

    public GeoCentroidAggregation(Builder builder) {
        super(builder);
        this.count = builder.count;
        this.location = builder.location;
    }

    public GeoCentroidAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_centroid";
    }

    @Nullable
    public Long count() {
        return this.count;
    }

    @Nullable
    public JsonValue location() {
        return this.location;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        if (this.location != null) {
            generator.writeKey("location");
            generator.write(this.location);
        }
    }

    protected static void setupGeoCentroidAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::location, JsonpDeserializer.jsonValueDeserializer(), "location", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoCentroidAggregation> {
        @Nullable
        private Long count;
        @Nullable
        private JsonValue location;

        public Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public Builder location(@Nullable JsonValue value) {
            this.location = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoCentroidAggregation build() {
            return new GeoCentroidAggregation(this);
        }
    }
}

