/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.LatLon;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GeoBounds
implements JsonpSerializable {
    private final LatLon bottomRight;
    private final LatLon topLeft;
    public static final JsonpDeserializer<GeoBounds> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBounds::setupGeoBoundsDeserializer, Builder::build);

    public GeoBounds(Builder builder) {
        this.bottomRight = Objects.requireNonNull(builder.bottomRight, "bottom_right");
        this.topLeft = Objects.requireNonNull(builder.topLeft, "top_left");
    }

    public GeoBounds(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public LatLon bottomRight() {
        return this.bottomRight;
    }

    public LatLon topLeft() {
        return this.topLeft;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bottom_right");
        this.bottomRight.serialize(generator, mapper);
        generator.writeKey("top_left");
        this.topLeft.serialize(generator, mapper);
    }

    protected static void setupGeoBoundsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bottomRight, LatLon._DESERIALIZER, "bottom_right", new String[0]);
        op.add(Builder::topLeft, LatLon._DESERIALIZER, "top_left", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GeoBounds> {
        private LatLon bottomRight;
        private LatLon topLeft;

        public Builder bottomRight(LatLon value) {
            this.bottomRight = value;
            return this;
        }

        public Builder bottomRight(Function<LatLon.Builder, ObjectBuilder<LatLon>> fn) {
            return this.bottomRight(fn.apply(new LatLon.Builder()).build());
        }

        public Builder topLeft(LatLon value) {
            this.topLeft = value;
            return this;
        }

        public Builder topLeft(Function<LatLon.Builder, ObjectBuilder<LatLon>> fn) {
            return this.topLeft(fn.apply(new LatLon.Builder()).build());
        }

        @Override
        public GeoBounds build() {
            return new GeoBounds(this);
        }
    }
}

