/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.SamplerAggregationExecutionHint;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DiversifiedSamplerAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final SamplerAggregationExecutionHint executionHint;
    @Nullable
    private final Integer maxDocsPerValue;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final String field;
    public static final JsonpDeserializer<DiversifiedSamplerAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiversifiedSamplerAggregation::setupDiversifiedSamplerAggregationDeserializer, Builder::build);

    public DiversifiedSamplerAggregation(Builder builder) {
        super(builder);
        this.executionHint = builder.executionHint;
        this.maxDocsPerValue = builder.maxDocsPerValue;
        this.script = builder.script;
        this.shardSize = builder.shardSize;
        this.field = builder.field;
    }

    public DiversifiedSamplerAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "diversified_sampler";
    }

    @Nullable
    public SamplerAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public Integer maxDocsPerValue() {
        return this.maxDocsPerValue;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.maxDocsPerValue != null) {
            generator.writeKey("max_docs_per_value");
            generator.write(this.maxDocsPerValue.intValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
    }

    protected static void setupDiversifiedSamplerAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::executionHint, SamplerAggregationExecutionHint._DESERIALIZER, "execution_hint", new String[0]);
        op.add(Builder::maxDocsPerValue, JsonpDeserializer.integerDeserializer(), "max_docs_per_value", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DiversifiedSamplerAggregation> {
        @Nullable
        private SamplerAggregationExecutionHint executionHint;
        @Nullable
        private Integer maxDocsPerValue;
        @Nullable
        private JsonValue script;
        @Nullable
        private Integer shardSize;
        @Nullable
        private String field;

        public Builder executionHint(@Nullable SamplerAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        public Builder maxDocsPerValue(@Nullable Integer value) {
            this.maxDocsPerValue = value;
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DiversifiedSamplerAggregation build() {
            return new DiversifiedSamplerAggregation(this);
        }
    }
}

