/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ClassificationInferenceOptions
implements JsonpSerializable {
    @Nullable
    private final Integer numTopClasses;
    @Nullable
    private final Integer numTopFeatureImportanceValues;
    @Nullable
    private final String predictionFieldType;
    @Nullable
    private final String resultsField;
    @Nullable
    private final String topClassesResultsField;
    public static final JsonpDeserializer<ClassificationInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClassificationInferenceOptions::setupClassificationInferenceOptionsDeserializer, Builder::build);

    public ClassificationInferenceOptions(Builder builder) {
        this.numTopClasses = builder.numTopClasses;
        this.numTopFeatureImportanceValues = builder.numTopFeatureImportanceValues;
        this.predictionFieldType = builder.predictionFieldType;
        this.resultsField = builder.resultsField;
        this.topClassesResultsField = builder.topClassesResultsField;
    }

    public ClassificationInferenceOptions(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Nullable
    public Integer numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Nullable
    public String predictionFieldType() {
        return this.predictionFieldType;
    }

    @Nullable
    public String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public String topClassesResultsField() {
        return this.topClassesResultsField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
        if (this.numTopFeatureImportanceValues != null) {
            generator.writeKey("num_top_feature_importance_values");
            generator.write(this.numTopFeatureImportanceValues.intValue());
        }
        if (this.predictionFieldType != null) {
            generator.writeKey("prediction_field_type");
            generator.write(this.predictionFieldType);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.topClassesResultsField != null) {
            generator.writeKey("top_classes_results_field");
            generator.write(this.topClassesResultsField);
        }
    }

    protected static void setupClassificationInferenceOptionsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes", new String[0]);
        op.add(Builder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values", new String[0]);
        op.add(Builder::predictionFieldType, JsonpDeserializer.stringDeserializer(), "prediction_field_type", new String[0]);
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field", new String[0]);
        op.add(Builder::topClassesResultsField, JsonpDeserializer.stringDeserializer(), "top_classes_results_field", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClassificationInferenceOptions> {
        @Nullable
        private Integer numTopClasses;
        @Nullable
        private Integer numTopFeatureImportanceValues;
        @Nullable
        private String predictionFieldType;
        @Nullable
        private String resultsField;
        @Nullable
        private String topClassesResultsField;

        public Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        public Builder numTopFeatureImportanceValues(@Nullable Integer value) {
            this.numTopFeatureImportanceValues = value;
            return this;
        }

        public Builder predictionFieldType(@Nullable String value) {
            this.predictionFieldType = value;
            return this;
        }

        public Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public Builder topClassesResultsField(@Nullable String value) {
            this.topClassesResultsField = value;
            return this;
        }

        @Override
        public ClassificationInferenceOptions build() {
            return new ClassificationInferenceOptions(this);
        }
    }
}

