/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BoxplotAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Double compression;
    public static final JsonpDeserializer<BoxplotAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoxplotAggregation::setupBoxplotAggregationDeserializer, Builder::build);

    public BoxplotAggregation(Builder builder) {
        super(builder);
        this.compression = builder.compression;
    }

    public BoxplotAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "boxplot";
    }

    @Nullable
    public Double compression() {
        return this.compression;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression.doubleValue());
        }
    }

    protected static void setupBoxplotAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::compression, JsonpDeserializer.doubleDeserializer(), "compression", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoxplotAggregation> {
        @Nullable
        private Double compression;

        public Builder compression(@Nullable Double value) {
            this.compression = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoxplotAggregation build() {
            return new BoxplotAggregation(this);
        }
    }
}

