/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TranslogStats
implements JsonpSerializable {
    private final long earliestLastModifiedAge;
    private final long operations;
    @Nullable
    private final String size;
    private final long sizeInBytes;
    private final int uncommittedOperations;
    @Nullable
    private final String uncommittedSize;
    private final long uncommittedSizeInBytes;
    public static final JsonpDeserializer<TranslogStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslogStats::setupTranslogStatsDeserializer, Builder::build);

    public TranslogStats(Builder builder) {
        this.earliestLastModifiedAge = Objects.requireNonNull(builder.earliestLastModifiedAge, "earliest_last_modified_age");
        this.operations = Objects.requireNonNull(builder.operations, "operations");
        this.size = builder.size;
        this.sizeInBytes = Objects.requireNonNull(builder.sizeInBytes, "size_in_bytes");
        this.uncommittedOperations = Objects.requireNonNull(builder.uncommittedOperations, "uncommitted_operations");
        this.uncommittedSize = builder.uncommittedSize;
        this.uncommittedSizeInBytes = Objects.requireNonNull(builder.uncommittedSizeInBytes, "uncommitted_size_in_bytes");
    }

    public TranslogStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long earliestLastModifiedAge() {
        return this.earliestLastModifiedAge;
    }

    public long operations() {
        return this.operations;
    }

    @Nullable
    public String size() {
        return this.size;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public int uncommittedOperations() {
        return this.uncommittedOperations;
    }

    @Nullable
    public String uncommittedSize() {
        return this.uncommittedSize;
    }

    public long uncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("earliest_last_modified_age");
        generator.write(this.earliestLastModifiedAge);
        generator.writeKey("operations");
        generator.write(this.operations);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("uncommitted_operations");
        generator.write(this.uncommittedOperations);
        if (this.uncommittedSize != null) {
            generator.writeKey("uncommitted_size");
            generator.write(this.uncommittedSize);
        }
        generator.writeKey("uncommitted_size_in_bytes");
        generator.write(this.uncommittedSizeInBytes);
    }

    protected static void setupTranslogStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::earliestLastModifiedAge, JsonpDeserializer.longDeserializer(), "earliest_last_modified_age", new String[0]);
        op.add(Builder::operations, JsonpDeserializer.longDeserializer(), "operations", new String[0]);
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size", new String[0]);
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes", new String[0]);
        op.add(Builder::uncommittedOperations, JsonpDeserializer.integerDeserializer(), "uncommitted_operations", new String[0]);
        op.add(Builder::uncommittedSize, JsonpDeserializer.stringDeserializer(), "uncommitted_size", new String[0]);
        op.add(Builder::uncommittedSizeInBytes, JsonpDeserializer.longDeserializer(), "uncommitted_size_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TranslogStats> {
        private Long earliestLastModifiedAge;
        private Long operations;
        @Nullable
        private String size;
        private Long sizeInBytes;
        private Integer uncommittedOperations;
        @Nullable
        private String uncommittedSize;
        private Long uncommittedSizeInBytes;

        public Builder earliestLastModifiedAge(long value) {
            this.earliestLastModifiedAge = value;
            return this;
        }

        public Builder operations(long value) {
            this.operations = value;
            return this;
        }

        public Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public Builder uncommittedOperations(int value) {
            this.uncommittedOperations = value;
            return this;
        }

        public Builder uncommittedSize(@Nullable String value) {
            this.uncommittedSize = value;
            return this;
        }

        public Builder uncommittedSizeInBytes(long value) {
            this.uncommittedSizeInBytes = value;
            return this;
        }

        @Override
        public TranslogStats build() {
            return new TranslogStats(this);
        }
    }
}

