/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StoredScript
implements JsonpSerializable {
    @Nullable
    private final ScriptLanguage lang;
    private final String source;
    public static final JsonpDeserializer<StoredScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StoredScript::setupStoredScriptDeserializer, Builder::build);

    public StoredScript(Builder builder) {
        this.lang = builder.lang;
        this.source = Objects.requireNonNull(builder.source, "source");
    }

    public StoredScript(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public ScriptLanguage lang() {
        return this.lang;
    }

    public String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.lang != null) {
            generator.writeKey("lang");
            this.lang.serialize(generator, mapper);
        }
        generator.writeKey("source");
        generator.write(this.source);
    }

    protected static void setupStoredScriptDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::lang, ScriptLanguage._DESERIALIZER, "lang", new String[0]);
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StoredScript> {
        @Nullable
        private ScriptLanguage lang;
        private String source;

        public Builder lang(@Nullable ScriptLanguage value) {
            this.lang = value;
            return this;
        }

        public Builder source(String value) {
            this.source = value;
            return this;
        }

        @Override
        public StoredScript build() {
            return new StoredScript(this);
        }
    }
}

