/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SearchStats
implements JsonpSerializable {
    private final long fetchCurrent;
    private final long fetchTimeInMillis;
    private final long fetchTotal;
    @Nullable
    private final Long openContexts;
    private final long queryCurrent;
    private final long queryTimeInMillis;
    private final long queryTotal;
    private final long scrollCurrent;
    private final long scrollTimeInMillis;
    private final long scrollTotal;
    private final long suggestCurrent;
    private final long suggestTimeInMillis;
    private final long suggestTotal;
    @Nullable
    private final Map<String, SearchStats> groups;
    public static final JsonpDeserializer<SearchStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchStats::setupSearchStatsDeserializer, Builder::build);

    public SearchStats(Builder builder) {
        this.fetchCurrent = Objects.requireNonNull(builder.fetchCurrent, "fetch_current");
        this.fetchTimeInMillis = Objects.requireNonNull(builder.fetchTimeInMillis, "fetch_time_in_millis");
        this.fetchTotal = Objects.requireNonNull(builder.fetchTotal, "fetch_total");
        this.openContexts = builder.openContexts;
        this.queryCurrent = Objects.requireNonNull(builder.queryCurrent, "query_current");
        this.queryTimeInMillis = Objects.requireNonNull(builder.queryTimeInMillis, "query_time_in_millis");
        this.queryTotal = Objects.requireNonNull(builder.queryTotal, "query_total");
        this.scrollCurrent = Objects.requireNonNull(builder.scrollCurrent, "scroll_current");
        this.scrollTimeInMillis = Objects.requireNonNull(builder.scrollTimeInMillis, "scroll_time_in_millis");
        this.scrollTotal = Objects.requireNonNull(builder.scrollTotal, "scroll_total");
        this.suggestCurrent = Objects.requireNonNull(builder.suggestCurrent, "suggest_current");
        this.suggestTimeInMillis = Objects.requireNonNull(builder.suggestTimeInMillis, "suggest_time_in_millis");
        this.suggestTotal = Objects.requireNonNull(builder.suggestTotal, "suggest_total");
        this.groups = ModelTypeHelper.unmodifiable(builder.groups);
    }

    public SearchStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long fetchCurrent() {
        return this.fetchCurrent;
    }

    public long fetchTimeInMillis() {
        return this.fetchTimeInMillis;
    }

    public long fetchTotal() {
        return this.fetchTotal;
    }

    @Nullable
    public Long openContexts() {
        return this.openContexts;
    }

    public long queryCurrent() {
        return this.queryCurrent;
    }

    public long queryTimeInMillis() {
        return this.queryTimeInMillis;
    }

    public long queryTotal() {
        return this.queryTotal;
    }

    public long scrollCurrent() {
        return this.scrollCurrent;
    }

    public long scrollTimeInMillis() {
        return this.scrollTimeInMillis;
    }

    public long scrollTotal() {
        return this.scrollTotal;
    }

    public long suggestCurrent() {
        return this.suggestCurrent;
    }

    public long suggestTimeInMillis() {
        return this.suggestTimeInMillis;
    }

    public long suggestTotal() {
        return this.suggestTotal;
    }

    @Nullable
    public Map<String, SearchStats> groups() {
        return this.groups;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fetch_current");
        generator.write(this.fetchCurrent);
        generator.writeKey("fetch_time_in_millis");
        generator.write(this.fetchTimeInMillis);
        generator.writeKey("fetch_total");
        generator.write(this.fetchTotal);
        if (this.openContexts != null) {
            generator.writeKey("open_contexts");
            generator.write(this.openContexts.longValue());
        }
        generator.writeKey("query_current");
        generator.write(this.queryCurrent);
        generator.writeKey("query_time_in_millis");
        generator.write(this.queryTimeInMillis);
        generator.writeKey("query_total");
        generator.write(this.queryTotal);
        generator.writeKey("scroll_current");
        generator.write(this.scrollCurrent);
        generator.writeKey("scroll_time_in_millis");
        generator.write(this.scrollTimeInMillis);
        generator.writeKey("scroll_total");
        generator.write(this.scrollTotal);
        generator.writeKey("suggest_current");
        generator.write(this.suggestCurrent);
        generator.writeKey("suggest_time_in_millis");
        generator.write(this.suggestTimeInMillis);
        generator.writeKey("suggest_total");
        generator.write(this.suggestTotal);
        if (this.groups != null) {
            generator.writeKey("groups");
            generator.writeStartObject();
            for (Map.Entry<String, SearchStats> item0 : this.groups.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSearchStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fetchCurrent, JsonpDeserializer.longDeserializer(), "fetch_current", new String[0]);
        op.add(Builder::fetchTimeInMillis, JsonpDeserializer.longDeserializer(), "fetch_time_in_millis", new String[0]);
        op.add(Builder::fetchTotal, JsonpDeserializer.longDeserializer(), "fetch_total", new String[0]);
        op.add(Builder::openContexts, JsonpDeserializer.longDeserializer(), "open_contexts", new String[0]);
        op.add(Builder::queryCurrent, JsonpDeserializer.longDeserializer(), "query_current", new String[0]);
        op.add(Builder::queryTimeInMillis, JsonpDeserializer.longDeserializer(), "query_time_in_millis", new String[0]);
        op.add(Builder::queryTotal, JsonpDeserializer.longDeserializer(), "query_total", new String[0]);
        op.add(Builder::scrollCurrent, JsonpDeserializer.longDeserializer(), "scroll_current", new String[0]);
        op.add(Builder::scrollTimeInMillis, JsonpDeserializer.longDeserializer(), "scroll_time_in_millis", new String[0]);
        op.add(Builder::scrollTotal, JsonpDeserializer.longDeserializer(), "scroll_total", new String[0]);
        op.add(Builder::suggestCurrent, JsonpDeserializer.longDeserializer(), "suggest_current", new String[0]);
        op.add(Builder::suggestTimeInMillis, JsonpDeserializer.longDeserializer(), "suggest_time_in_millis", new String[0]);
        op.add(Builder::suggestTotal, JsonpDeserializer.longDeserializer(), "suggest_total", new String[0]);
        op.add(Builder::groups, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "groups", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SearchStats> {
        private Long fetchCurrent;
        private Long fetchTimeInMillis;
        private Long fetchTotal;
        @Nullable
        private Long openContexts;
        private Long queryCurrent;
        private Long queryTimeInMillis;
        private Long queryTotal;
        private Long scrollCurrent;
        private Long scrollTimeInMillis;
        private Long scrollTotal;
        private Long suggestCurrent;
        private Long suggestTimeInMillis;
        private Long suggestTotal;
        @Nullable
        private Map<String, SearchStats> groups;

        public Builder fetchCurrent(long value) {
            this.fetchCurrent = value;
            return this;
        }

        public Builder fetchTimeInMillis(long value) {
            this.fetchTimeInMillis = value;
            return this;
        }

        public Builder fetchTotal(long value) {
            this.fetchTotal = value;
            return this;
        }

        public Builder openContexts(@Nullable Long value) {
            this.openContexts = value;
            return this;
        }

        public Builder queryCurrent(long value) {
            this.queryCurrent = value;
            return this;
        }

        public Builder queryTimeInMillis(long value) {
            this.queryTimeInMillis = value;
            return this;
        }

        public Builder queryTotal(long value) {
            this.queryTotal = value;
            return this;
        }

        public Builder scrollCurrent(long value) {
            this.scrollCurrent = value;
            return this;
        }

        public Builder scrollTimeInMillis(long value) {
            this.scrollTimeInMillis = value;
            return this;
        }

        public Builder scrollTotal(long value) {
            this.scrollTotal = value;
            return this;
        }

        public Builder suggestCurrent(long value) {
            this.suggestCurrent = value;
            return this;
        }

        public Builder suggestTimeInMillis(long value) {
            this.suggestTimeInMillis = value;
            return this;
        }

        public Builder suggestTotal(long value) {
            this.suggestTotal = value;
            return this;
        }

        public Builder groups(@Nullable Map<String, SearchStats> value) {
            this.groups = value;
            return this;
        }

        public Builder putGroups(String key, SearchStats value) {
            if (this.groups == null) {
                this.groups = new HashMap<String, SearchStats>();
            }
            this.groups.put(key, value);
            return this;
        }

        public Builder groups(String key, Function<Builder, ObjectBuilder<SearchStats>> fn) {
            return this.groups(Collections.singletonMap(key, fn.apply(new Builder()).build()));
        }

        public Builder putGroups(String key, Function<Builder, ObjectBuilder<SearchStats>> fn) {
            return this.putGroups(key, fn.apply(new Builder()).build());
        }

        @Override
        public SearchStats build() {
            return new SearchStats(this);
        }
    }
}

