/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeStatistics
implements JsonpSerializable {
    @Nullable
    private final List<ErrorCause> failures;
    private final int total;
    private final int successful;
    private final int failed;
    public static final JsonpDeserializer<NodeStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeStatistics::setupNodeStatisticsDeserializer, Builder::build);

    public NodeStatistics(Builder builder) {
        this.failures = ModelTypeHelper.unmodifiable(builder.failures);
        this.total = Objects.requireNonNull(builder.total, "total");
        this.successful = Objects.requireNonNull(builder.successful, "successful");
        this.failed = Objects.requireNonNull(builder.failed, "failed");
    }

    public NodeStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<ErrorCause> failures() {
        return this.failures;
    }

    public int total() {
        return this.total;
    }

    public int successful() {
        return this.successful;
    }

    public int failed() {
        return this.failed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.failures != null) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ErrorCause item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("successful");
        generator.write(this.successful);
        generator.writeKey("failed");
        generator.write(this.failed);
    }

    protected static void setupNodeStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "failures", new String[0]);
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total", new String[0]);
        op.add(Builder::successful, JsonpDeserializer.integerDeserializer(), "successful", new String[0]);
        op.add(Builder::failed, JsonpDeserializer.integerDeserializer(), "failed", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeStatistics> {
        @Nullable
        private List<ErrorCause> failures;
        private Integer total;
        private Integer successful;
        private Integer failed;

        public Builder failures(@Nullable List<ErrorCause> value) {
            this.failures = value;
            return this;
        }

        public Builder failures(ErrorCause ... value) {
            this.failures = Arrays.asList(value);
            return this;
        }

        public Builder addFailures(ErrorCause value) {
            if (this.failures == null) {
                this.failures = new ArrayList<ErrorCause>();
            }
            this.failures.add(value);
            return this;
        }

        public Builder failures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.failures(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder addFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.addFailures(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder total(int value) {
            this.total = value;
            return this;
        }

        public Builder successful(int value) {
            this.successful = value;
            return this;
        }

        public Builder failed(int value) {
            this.failed = value;
            return this;
        }

        @Override
        public NodeStatistics build() {
            return new NodeStatistics(this);
        }
    }
}

