/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.UnassignedInformation;
import co.elastic.clients.elasticsearch.indices.stats.ShardRoutingState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeShard
implements JsonpSerializable {
    private final ShardRoutingState state;
    private final boolean primary;
    @Nullable
    private final String node;
    private final int shard;
    private final String index;
    @Nullable
    private final Map<String, String> allocationId;
    @Nullable
    private final Map<String, String> recoverySource;
    @Nullable
    private final UnassignedInformation unassignedInfo;
    public static final JsonpDeserializer<NodeShard> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeShard::setupNodeShardDeserializer, Builder::build);

    public NodeShard(Builder builder) {
        this.state = Objects.requireNonNull(builder.state, "state");
        this.primary = Objects.requireNonNull(builder.primary, "primary");
        this.node = builder.node;
        this.shard = Objects.requireNonNull(builder.shard, "shard");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.allocationId = ModelTypeHelper.unmodifiable(builder.allocationId);
        this.recoverySource = ModelTypeHelper.unmodifiable(builder.recoverySource);
        this.unassignedInfo = builder.unassignedInfo;
    }

    public NodeShard(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardRoutingState state() {
        return this.state;
    }

    public boolean primary() {
        return this.primary;
    }

    @Nullable
    public String node() {
        return this.node;
    }

    public int shard() {
        return this.shard;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Map<String, String> allocationId() {
        return this.allocationId;
    }

    @Nullable
    public Map<String, String> recoverySource() {
        return this.recoverySource;
    }

    @Nullable
    public UnassignedInformation unassignedInfo() {
        return this.unassignedInfo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
        generator.writeKey("shard");
        generator.write(this.shard);
        generator.writeKey("index");
        generator.write(this.index);
        if (this.allocationId != null) {
            generator.writeKey("allocation_id");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.allocationId.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.recoverySource != null) {
            generator.writeKey("recovery_source");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.recoverySource.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.unassignedInfo != null) {
            generator.writeKey("unassigned_info");
            this.unassignedInfo.serialize(generator, mapper);
        }
    }

    protected static void setupNodeShardDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::state, ShardRoutingState._DESERIALIZER, "state", new String[0]);
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::allocationId, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "allocation_id", new String[0]);
        op.add(Builder::recoverySource, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "recovery_source", new String[0]);
        op.add(Builder::unassignedInfo, UnassignedInformation._DESERIALIZER, "unassigned_info", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeShard> {
        private ShardRoutingState state;
        private Boolean primary;
        @Nullable
        private String node;
        private Integer shard;
        private String index;
        @Nullable
        private Map<String, String> allocationId;
        @Nullable
        private Map<String, String> recoverySource;
        @Nullable
        private UnassignedInformation unassignedInfo;

        public Builder state(ShardRoutingState value) {
            this.state = value;
            return this;
        }

        public Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder allocationId(@Nullable Map<String, String> value) {
            this.allocationId = value;
            return this;
        }

        public Builder putAllocationId(String key, String value) {
            if (this.allocationId == null) {
                this.allocationId = new HashMap<String, String>();
            }
            this.allocationId.put(key, value);
            return this;
        }

        public Builder recoverySource(@Nullable Map<String, String> value) {
            this.recoverySource = value;
            return this;
        }

        public Builder putRecoverySource(String key, String value) {
            if (this.recoverySource == null) {
                this.recoverySource = new HashMap<String, String>();
            }
            this.recoverySource.put(key, value);
            return this;
        }

        public Builder unassignedInfo(@Nullable UnassignedInformation value) {
            this.unassignedInfo = value;
            return this;
        }

        public Builder unassignedInfo(Function<UnassignedInformation.Builder, ObjectBuilder<UnassignedInformation>> fn) {
            return this.unassignedInfo(fn.apply(new UnassignedInformation.Builder()).build());
        }

        @Override
        public NodeShard build() {
            return new NodeShard(this);
        }
    }
}

