/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class InlineGet<TDocument>
implements JsonpSerializable {
    @Nullable
    private final Map<String, JsonData> fields;
    private final boolean found;
    private final int seqNo;
    private final long primaryTerm;
    @Nullable
    private final String routing;
    private final TDocument source;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public InlineGet(Builder<TDocument> builder) {
        this.fields = ModelTypeHelper.unmodifiable(((Builder)builder).fields);
        this.found = Objects.requireNonNull(((Builder)builder).found, "found");
        this.seqNo = Objects.requireNonNull(((Builder)builder).seqNo, "_seq_no");
        this.primaryTerm = Objects.requireNonNull(((Builder)builder).primaryTerm, "_primary_term");
        this.routing = ((Builder)builder).routing;
        this.source = Objects.requireNonNull(((Builder)builder).source, "_source");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public InlineGet(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, JsonData> fields() {
        return this.fields;
    }

    public boolean found() {
        return this.found;
    }

    public int seqNo() {
        return this.seqNo;
    }

    public long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    public TDocument source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("_seq_no");
        generator.write(this.seqNo);
        generator.writeKey("_primary_term");
        generator.write(this.primaryTerm);
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        generator.writeKey("_source");
        JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
    }

    public static <TDocument> JsonpDeserializer<InlineGet<TDocument>> createInlineGetDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> InlineGet.setupInlineGetDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupInlineGetDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields", new String[0]);
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found", new String[0]);
        op.add(Builder::seqNo, JsonpDeserializer.integerDeserializer(), "_seq_no", new String[0]);
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing", new String[0]);
        op.add(Builder::source, tDocumentDeserializer, "_source", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<InlineGet<TDocument>> {
        @Nullable
        private Map<String, JsonData> fields;
        private Boolean found;
        private Integer seqNo;
        private Long primaryTerm;
        @Nullable
        private String routing;
        private TDocument source;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> fields(@Nullable Map<String, JsonData> value) {
            this.fields = value;
            return this;
        }

        public Builder<TDocument> putFields(String key, JsonData value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, JsonData>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder<TDocument> found(boolean value) {
            this.found = value;
            return this;
        }

        public Builder<TDocument> seqNo(int value) {
            this.seqNo = value;
            return this;
        }

        public Builder<TDocument> primaryTerm(long value) {
            this.primaryTerm = value;
            return this;
        }

        public Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder<TDocument> source(TDocument value) {
            this.source = value;
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public InlineGet<TDocument> build() {
            return new InlineGet(this);
        }
    }
}

