/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class IndicesResponseBase
extends AcknowledgedResponseBase {
    @Nullable
    private final ShardStatistics shards;

    public IndicesResponseBase(AbstractBuilder<?> builder) {
        super(builder);
        this.shards = ((AbstractBuilder)builder).shards;
    }

    @Nullable
    public ShardStatistics shards() {
        return this.shards;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupIndicesResponseBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AcknowledgedResponseBase.AbstractBuilder<BuilderT> {
        @Nullable
        private ShardStatistics shards;

        protected AbstractBuilder() {
        }

        public BuilderT shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }
    }
}

