/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterStatistics
implements JsonpSerializable {
    private final int skipped;
    private final int successful;
    private final int total;
    public static final JsonpDeserializer<ClusterStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStatistics::setupClusterStatisticsDeserializer, Builder::build);

    public ClusterStatistics(Builder builder) {
        this.skipped = Objects.requireNonNull(builder.skipped, "skipped");
        this.successful = Objects.requireNonNull(builder.successful, "successful");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public ClusterStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int skipped() {
        return this.skipped;
    }

    public int successful() {
        return this.successful;
    }

    public int total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("skipped");
        generator.write(this.skipped);
        generator.writeKey("successful");
        generator.write(this.successful);
        generator.writeKey("total");
        generator.write(this.total);
    }

    protected static void setupClusterStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::skipped, JsonpDeserializer.integerDeserializer(), "skipped", new String[0]);
        op.add(Builder::successful, JsonpDeserializer.integerDeserializer(), "successful", new String[0]);
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterStatistics> {
        private Integer skipped;
        private Integer successful;
        private Integer total;

        public Builder skipped(int value) {
            this.skipped = value;
            return this;
        }

        public Builder successful(int value) {
            this.successful = value;
            return this;
        }

        public Builder total(int value) {
            this.total = value;
            return this;
        }

        @Override
        public ClusterStatistics build() {
            return new ClusterStatistics(this);
        }
    }
}

