/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.termvectors;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Token
implements JsonpSerializable {
    @Nullable
    private final Integer endOffset;
    @Nullable
    private final String payload;
    private final int position;
    @Nullable
    private final Integer startOffset;
    public static final JsonpDeserializer<Token> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Token::setupTokenDeserializer, Builder::build);

    public Token(Builder builder) {
        this.endOffset = builder.endOffset;
        this.payload = builder.payload;
        this.position = Objects.requireNonNull(builder.position, "position");
        this.startOffset = builder.startOffset;
    }

    public Token(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer endOffset() {
        return this.endOffset;
    }

    @Nullable
    public String payload() {
        return this.payload;
    }

    public int position() {
        return this.position;
    }

    @Nullable
    public Integer startOffset() {
        return this.startOffset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.endOffset != null) {
            generator.writeKey("end_offset");
            generator.write(this.endOffset.intValue());
        }
        if (this.payload != null) {
            generator.writeKey("payload");
            generator.write(this.payload);
        }
        generator.writeKey("position");
        generator.write(this.position);
        if (this.startOffset != null) {
            generator.writeKey("start_offset");
            generator.write(this.startOffset.intValue());
        }
    }

    protected static void setupTokenDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::endOffset, JsonpDeserializer.integerDeserializer(), "end_offset", new String[0]);
        op.add(Builder::payload, JsonpDeserializer.stringDeserializer(), "payload", new String[0]);
        op.add(Builder::position, JsonpDeserializer.integerDeserializer(), "position", new String[0]);
        op.add(Builder::startOffset, JsonpDeserializer.integerDeserializer(), "start_offset", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Token> {
        @Nullable
        private Integer endOffset;
        @Nullable
        private String payload;
        private Integer position;
        @Nullable
        private Integer startOffset;

        public Builder endOffset(@Nullable Integer value) {
            this.endOffset = value;
            return this;
        }

        public Builder payload(@Nullable String value) {
            this.payload = value;
            return this;
        }

        public Builder position(int value) {
            this.position = value;
            return this;
        }

        public Builder startOffset(@Nullable Integer value) {
            this.startOffset = value;
            return this;
        }

        @Override
        public Token build() {
            return new Token(this);
        }
    }
}

