/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.termvectors;

import co.elastic.clients.elasticsearch._core.termvectors.FieldStatistics;
import co.elastic.clients.elasticsearch._core.termvectors.Term;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TermVector
implements JsonpSerializable {
    private final FieldStatistics fieldStatistics;
    private final Map<String, Term> terms;
    public static final JsonpDeserializer<TermVector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermVector::setupTermVectorDeserializer, Builder::build);

    public TermVector(Builder builder) {
        this.fieldStatistics = Objects.requireNonNull(builder.fieldStatistics, "field_statistics");
        this.terms = ModelTypeHelper.unmodifiableNonNull(builder.terms, "terms");
    }

    public TermVector(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public FieldStatistics fieldStatistics() {
        return this.fieldStatistics;
    }

    public Map<String, Term> terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field_statistics");
        this.fieldStatistics.serialize(generator, mapper);
        generator.writeKey("terms");
        generator.writeStartObject();
        for (Map.Entry<String, Term> item0 : this.terms.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTermVectorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fieldStatistics, FieldStatistics._DESERIALIZER, "field_statistics", new String[0]);
        op.add(Builder::terms, JsonpDeserializer.stringMapDeserializer(Term._DESERIALIZER), "terms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TermVector> {
        private FieldStatistics fieldStatistics;
        private Map<String, Term> terms;

        public Builder fieldStatistics(FieldStatistics value) {
            this.fieldStatistics = value;
            return this;
        }

        public Builder fieldStatistics(Function<FieldStatistics.Builder, ObjectBuilder<FieldStatistics>> fn) {
            return this.fieldStatistics(fn.apply(new FieldStatistics.Builder()).build());
        }

        public Builder terms(Map<String, Term> value) {
            this.terms = value;
            return this;
        }

        public Builder putTerms(String key, Term value) {
            if (this.terms == null) {
                this.terms = new HashMap<String, Term>();
            }
            this.terms.put(key, value);
            return this;
        }

        public Builder terms(String key, Function<Term.Builder, ObjectBuilder<Term>> fn) {
            return this.terms(Collections.singletonMap(key, fn.apply(new Term.Builder()).build()));
        }

        public Builder putTerms(String key, Function<Term.Builder, ObjectBuilder<Term>> fn) {
            return this.putTerms(key, fn.apply(new Term.Builder()).build());
        }

        @Override
        public TermVector build() {
            return new TermVector(this);
        }
    }
}

