/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.elasticsearch._core.search.SuggestFuzziness;
import co.elastic.clients.elasticsearch._core.search.SuggestVariant;
import co.elastic.clients.elasticsearch._core.search.SuggesterBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CompletionSuggester
extends SuggesterBase
implements SuggestVariant {
    @Nullable
    private final Map<String, JsonValue> contexts;
    @Nullable
    private final SuggestFuzziness fuzzy;
    @Nullable
    private final String prefix;
    @Nullable
    private final String regex;
    @Nullable
    private final Boolean skipDuplicates;
    public static final JsonpDeserializer<CompletionSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionSuggester::setupCompletionSuggesterDeserializer, Builder::build);

    public CompletionSuggester(Builder builder) {
        super(builder);
        this.contexts = ModelTypeHelper.unmodifiable(builder.contexts);
        this.fuzzy = builder.fuzzy;
        this.prefix = builder.prefix;
        this.regex = builder.regex;
        this.skipDuplicates = builder.skipDuplicates;
    }

    public CompletionSuggester(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "completion";
    }

    @Nullable
    public Map<String, JsonValue> contexts() {
        return this.contexts;
    }

    @Nullable
    public SuggestFuzziness fuzzy() {
        return this.fuzzy;
    }

    @Nullable
    public String prefix() {
        return this.prefix;
    }

    @Nullable
    public String regex() {
        return this.regex;
    }

    @Nullable
    public Boolean skipDuplicates() {
        return this.skipDuplicates;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.contexts != null) {
            generator.writeKey("contexts");
            generator.writeStartObject();
            for (Map.Entry<String, JsonValue> item0 : this.contexts.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.fuzzy != null) {
            generator.writeKey("fuzzy");
            this.fuzzy.serialize(generator, mapper);
        }
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix);
        }
        if (this.regex != null) {
            generator.writeKey("regex");
            generator.write(this.regex);
        }
        if (this.skipDuplicates != null) {
            generator.writeKey("skip_duplicates");
            generator.write(this.skipDuplicates.booleanValue());
        }
    }

    protected static void setupCompletionSuggesterDeserializer(DelegatingDeserializer<Builder> op) {
        SuggesterBase.setupSuggesterBaseDeserializer(op);
        op.add(Builder::contexts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.jsonValueDeserializer()), "contexts", new String[0]);
        op.add(Builder::fuzzy, SuggestFuzziness._DESERIALIZER, "fuzzy", new String[0]);
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix", new String[0]);
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), "regex", new String[0]);
        op.add(Builder::skipDuplicates, JsonpDeserializer.booleanDeserializer(), "skip_duplicates", new String[0]);
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompletionSuggester> {
        @Nullable
        private Map<String, JsonValue> contexts;
        @Nullable
        private SuggestFuzziness fuzzy;
        @Nullable
        private String prefix;
        @Nullable
        private String regex;
        @Nullable
        private Boolean skipDuplicates;

        public Builder contexts(@Nullable Map<String, JsonValue> value) {
            this.contexts = value;
            return this;
        }

        public Builder putContexts(String key, JsonValue value) {
            if (this.contexts == null) {
                this.contexts = new HashMap<String, JsonValue>();
            }
            this.contexts.put(key, value);
            return this;
        }

        public Builder fuzzy(@Nullable SuggestFuzziness value) {
            this.fuzzy = value;
            return this;
        }

        public Builder fuzzy(Function<SuggestFuzziness.Builder, ObjectBuilder<SuggestFuzziness>> fn) {
            return this.fuzzy(fn.apply(new SuggestFuzziness.Builder()).build());
        }

        public Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        public Builder regex(@Nullable String value) {
            this.regex = value;
            return this;
        }

        public Builder skipDuplicates(@Nullable Boolean value) {
            this.skipDuplicates = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompletionSuggester build() {
            return new CompletionSuggester(this);
        }
    }
}

