/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.get_script_context;

import co.elastic.clients.elasticsearch._core.get_script_context.ContextMethodParam;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ContextMethod
implements JsonpSerializable {
    private final String name;
    private final String returnType;
    private final List<ContextMethodParam> params;
    public static final JsonpDeserializer<ContextMethod> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ContextMethod::setupContextMethodDeserializer, Builder::build);

    public ContextMethod(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.returnType = Objects.requireNonNull(builder.returnType, "return_type");
        this.params = ModelTypeHelper.unmodifiableNonNull(builder.params, "params");
    }

    public ContextMethod(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public String returnType() {
        return this.returnType;
    }

    public List<ContextMethodParam> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("return_type");
        generator.write(this.returnType);
        generator.writeKey("params");
        generator.writeStartArray();
        for (ContextMethodParam item0 : this.params) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupContextMethodDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::returnType, JsonpDeserializer.stringDeserializer(), "return_type", new String[0]);
        op.add(Builder::params, JsonpDeserializer.arrayDeserializer(ContextMethodParam._DESERIALIZER), "params", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ContextMethod> {
        private String name;
        private String returnType;
        private List<ContextMethodParam> params;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder returnType(String value) {
            this.returnType = value;
            return this;
        }

        public Builder params(List<ContextMethodParam> value) {
            this.params = value;
            return this;
        }

        public Builder params(ContextMethodParam ... value) {
            this.params = Arrays.asList(value);
            return this;
        }

        public Builder addParams(ContextMethodParam value) {
            if (this.params == null) {
                this.params = new ArrayList<ContextMethodParam>();
            }
            this.params.add(value);
            return this;
        }

        public Builder params(Function<ContextMethodParam.Builder, ObjectBuilder<ContextMethodParam>> fn) {
            return this.params(fn.apply(new ContextMethodParam.Builder()).build());
        }

        public Builder addParams(Function<ContextMethodParam.Builder, ObjectBuilder<ContextMethodParam>> fn) {
            return this.addParams(fn.apply(new ContextMethodParam.Builder()).build());
        }

        @Override
        public ContextMethod build() {
            return new ContextMethod(this);
        }
    }
}

