/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.bulk;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.InlineGet;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ResponseItemBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final String index;
    private final int status;
    @Nullable
    private final ErrorCause error;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final String result;
    @Nullable
    private final Integer seqNo;
    @Nullable
    private final ShardStatistics shards;
    @Nullable
    private final String type;
    @Nullable
    private final Long version;
    @Nullable
    private final Boolean forcedRefresh;
    @Nullable
    private final InlineGet<Map<String, JsonData>> get;

    public ResponseItemBase(AbstractBuilder<?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.index = Objects.requireNonNull(((AbstractBuilder)builder).index, "_index");
        this.status = Objects.requireNonNull(((AbstractBuilder)builder).status, "status");
        this.error = ((AbstractBuilder)builder).error;
        this.primaryTerm = ((AbstractBuilder)builder).primaryTerm;
        this.result = ((AbstractBuilder)builder).result;
        this.seqNo = ((AbstractBuilder)builder).seqNo;
        this.shards = ((AbstractBuilder)builder).shards;
        this.type = ((AbstractBuilder)builder).type;
        this.version = ((AbstractBuilder)builder).version;
        this.forcedRefresh = ((AbstractBuilder)builder).forcedRefresh;
        this.get = ((AbstractBuilder)builder).get;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    public int status() {
        return this.status;
    }

    @Nullable
    public ErrorCause error() {
        return this.error;
    }

    @Nullable
    public Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public String result() {
        return this.result;
    }

    @Nullable
    public Integer seqNo() {
        return this.seqNo;
    }

    @Nullable
    public ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Nullable
    public InlineGet<Map<String, JsonData>> get() {
        return this.get;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("status");
        generator.write(this.status);
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.result != null) {
            generator.writeKey("result");
            generator.write(this.result);
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.intValue());
        }
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (this.forcedRefresh != null) {
            generator.writeKey("forced_refresh");
            generator.write(this.forcedRefresh.booleanValue());
        }
        if (this.get != null) {
            generator.writeKey("get");
            this.get.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupResponseItemBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(AbstractBuilder::status, JsonpDeserializer.integerDeserializer(), "status", new String[0]);
        op.add(AbstractBuilder::error, ErrorCause._DESERIALIZER, "error", new String[0]);
        op.add(AbstractBuilder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term", new String[0]);
        op.add(AbstractBuilder::result, JsonpDeserializer.stringDeserializer(), "result", new String[0]);
        op.add(AbstractBuilder::seqNo, JsonpDeserializer.integerDeserializer(), "_seq_no", new String[0]);
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(AbstractBuilder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "_version", new String[0]);
        op.add(AbstractBuilder::forcedRefresh, JsonpDeserializer.booleanDeserializer(), "forced_refresh", new String[0]);
        op.add(AbstractBuilder::get, InlineGet.createInlineGetDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "get", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private String id;
        private String index;
        private Integer status;
        @Nullable
        private ErrorCause error;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private String result;
        @Nullable
        private Integer seqNo;
        @Nullable
        private ShardStatistics shards;
        @Nullable
        private String type;
        @Nullable
        private Long version;
        @Nullable
        private Boolean forcedRefresh;
        @Nullable
        private InlineGet<Map<String, JsonData>> get;

        protected AbstractBuilder() {
        }

        public BuilderT id(@Nullable String value) {
            this.id = value;
            return this.self();
        }

        public BuilderT index(String value) {
            this.index = value;
            return this.self();
        }

        public BuilderT status(int value) {
            this.status = value;
            return this.self();
        }

        public BuilderT error(@Nullable ErrorCause value) {
            this.error = value;
            return this.self();
        }

        public BuilderT error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public BuilderT primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return this.self();
        }

        public BuilderT result(@Nullable String value) {
            this.result = value;
            return this.self();
        }

        public BuilderT seqNo(@Nullable Integer value) {
            this.seqNo = value;
            return this.self();
        }

        public BuilderT shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this.self();
        }

        public BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public BuilderT type(@Nullable String value) {
            this.type = value;
            return this.self();
        }

        public BuilderT version(@Nullable Long value) {
            this.version = value;
            return this.self();
        }

        public BuilderT forcedRefresh(@Nullable Boolean value) {
            this.forcedRefresh = value;
            return this.self();
        }

        public BuilderT get(@Nullable InlineGet<Map<String, JsonData>> value) {
            this.get = value;
            return this.self();
        }

        public BuilderT get(Function<InlineGet.Builder<Map<String, JsonData>>, ObjectBuilder<InlineGet<Map<String, JsonData>>>> fn) {
            return this.get(fn.apply(new InlineGet.Builder()).build());
        }

        protected abstract BuilderT self();
    }
}

