/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.ScriptsPainlessExecuteResponse;
import co.elastic.clients.elasticsearch._core.scripts_painless_execute.PainlessContextSetup;
import co.elastic.clients.elasticsearch._types.InlineScript;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ScriptsPainlessExecuteRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String context;
    @Nullable
    private final PainlessContextSetup contextSetup;
    @Nullable
    private final InlineScript script;
    public static final JsonpDeserializer<ScriptsPainlessExecuteRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptsPainlessExecuteRequest::setupScriptsPainlessExecuteRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<ScriptsPainlessExecuteRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> "/_scripts/painless/_execute", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, null);

    public ScriptsPainlessExecuteRequest(Builder builder) {
        this.context = builder.context;
        this.contextSetup = builder.contextSetup;
        this.script = builder.script;
    }

    public ScriptsPainlessExecuteRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String context() {
        return this.context;
    }

    @Nullable
    public PainlessContextSetup contextSetup() {
        return this.contextSetup;
    }

    @Nullable
    public InlineScript script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.context != null) {
            generator.writeKey("context");
            generator.write(this.context);
        }
        if (this.contextSetup != null) {
            generator.writeKey("context_setup");
            this.contextSetup.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupScriptsPainlessExecuteRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::context, JsonpDeserializer.stringDeserializer(), "context", new String[0]);
        op.add(Builder::contextSetup, PainlessContextSetup._DESERIALIZER, "context_setup", new String[0]);
        op.add(Builder::script, InlineScript._DESERIALIZER, "script", new String[0]);
    }

    public static <TResult> Endpoint<ScriptsPainlessExecuteRequest, ScriptsPainlessExecuteResponse<TResult>, ElasticsearchError> createScriptsPainlessExecuteEndpoint(JsonpDeserializer<TResult> tResultDeserializer) {
        return ENDPOINT.withResponseDeserializer(ScriptsPainlessExecuteResponse.createScriptsPainlessExecuteResponseDeserializer(tResultDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<ScriptsPainlessExecuteRequest> {
        @Nullable
        private String context;
        @Nullable
        private PainlessContextSetup contextSetup;
        @Nullable
        private InlineScript script;

        public Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        public Builder contextSetup(@Nullable PainlessContextSetup value) {
            this.contextSetup = value;
            return this;
        }

        public Builder contextSetup(Function<PainlessContextSetup.Builder, ObjectBuilder<PainlessContextSetup>> fn) {
            return this.contextSetup(fn.apply(new PainlessContextSetup.Builder()).build());
        }

        public Builder script(@Nullable InlineScript value) {
            this.script = value;
            return this;
        }

        public Builder script(Function<InlineScript.Builder, ObjectBuilder<InlineScript>> fn) {
            return this.script(fn.apply(new InlineScript.Builder()).build());
        }

        @Override
        public ScriptsPainlessExecuteRequest build() {
            return new ScriptsPainlessExecuteRequest(this);
        }
    }
}

