/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.ReindexResponse;
import co.elastic.clients.elasticsearch._core.reindex.Destination;
import co.elastic.clients.elasticsearch._core.reindex.Source;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ReindexRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final Long requestsPerSecond;
    @Nullable
    private final String scroll;
    @Nullable
    private final Long slices;
    @Nullable
    private final String timeout;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final Boolean waitForCompletion;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Conflicts conflicts;
    @Nullable
    private final Destination dest;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final Long size;
    @Nullable
    private final Source source;
    public static final JsonpDeserializer<ReindexRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexRequest::setupReindexRequestDeserializer, Builder::build);
    public static final Endpoint<ReindexRequest, ReindexResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ReindexRequest, ReindexResponse>(request -> "POST", request -> "/_reindex", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(request.requestsPerSecond));
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll);
        }
        if (request.slices != null) {
            params.put("slices", String.valueOf(request.slices));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ReindexResponse._DESERIALIZER);

    public ReindexRequest(Builder builder) {
        this.refresh = builder.refresh;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.scroll = builder.scroll;
        this.slices = builder.slices;
        this.timeout = builder.timeout;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.waitForCompletion = builder.waitForCompletion;
        this.requireAlias = builder.requireAlias;
        this.conflicts = builder.conflicts;
        this.dest = builder.dest;
        this.maxDocs = builder.maxDocs;
        this.script = builder.script;
        this.size = builder.size;
        this.source = builder.source;
    }

    public ReindexRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public String scroll() {
        return this.scroll;
    }

    @Nullable
    public Long slices() {
        return this.slices;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Nullable
    public Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public Conflicts conflicts() {
        return this.conflicts;
    }

    @Nullable
    public Destination dest() {
        return this.dest;
    }

    @Nullable
    public Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public Long size() {
        return this.size;
    }

    @Nullable
    public Source source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.conflicts != null) {
            generator.writeKey("conflicts");
            this.conflicts.serialize(generator, mapper);
        }
        if (this.dest != null) {
            generator.writeKey("dest");
            this.dest.serialize(generator, mapper);
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.longValue());
        }
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
    }

    protected static void setupReindexRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::conflicts, Conflicts._DESERIALIZER, "conflicts", new String[0]);
        op.add(Builder::dest, Destination._DESERIALIZER, "dest", new String[0]);
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::size, JsonpDeserializer.longDeserializer(), "size", new String[0]);
        op.add(Builder::source, Source._DESERIALIZER, "source", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReindexRequest> {
        @Nullable
        private Boolean refresh;
        @Nullable
        private Long requestsPerSecond;
        @Nullable
        private String scroll;
        @Nullable
        private Long slices;
        @Nullable
        private String timeout;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private Boolean waitForCompletion;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Conflicts conflicts;
        @Nullable
        private Destination dest;
        @Nullable
        private Long maxDocs;
        @Nullable
        private JsonValue script;
        @Nullable
        private Long size;
        @Nullable
        private Source source;

        public Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        public Builder scroll(@Nullable String value) {
            this.scroll = value;
            return this;
        }

        public Builder slices(@Nullable Long value) {
            this.slices = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        public Builder requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public Builder conflicts(@Nullable Conflicts value) {
            this.conflicts = value;
            return this;
        }

        public Builder dest(@Nullable Destination value) {
            this.dest = value;
            return this;
        }

        public Builder dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder size(@Nullable Long value) {
            this.size = value;
            return this;
        }

        public Builder source(@Nullable Source value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        @Override
        public ReindexRequest build() {
            return new ReindexRequest(this);
        }
    }
}

