/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.MtermvectorsResponse;
import co.elastic.clients.elasticsearch._core.mtermvectors.Operation;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MtermvectorsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Boolean fieldStatistics;
    @Nullable
    private final Boolean offsets;
    @Nullable
    private final Boolean payloads;
    @Nullable
    private final Boolean positions;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final String routing;
    @Nullable
    private final Boolean termStatistics;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final List<Operation> docs;
    @Nullable
    private final List<String> ids;
    public static final JsonpDeserializer<MtermvectorsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MtermvectorsRequest::setupMtermvectorsRequestDeserializer, Builder::build);
    public static final Endpoint<MtermvectorsRequest, MtermvectorsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<MtermvectorsRequest, MtermvectorsResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mtermvectors");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_mtermvectors");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_mtermvectors");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.fields != null) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.fieldStatistics != null) {
            params.put("field_statistics", String.valueOf(request.fieldStatistics));
        }
        if (request.offsets != null) {
            params.put("offsets", String.valueOf(request.offsets));
        }
        if (request.payloads != null) {
            params.put("payloads", String.valueOf(request.payloads));
        }
        if (request.positions != null) {
            params.put("positions", String.valueOf(request.positions));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.termStatistics != null) {
            params.put("term_statistics", String.valueOf(request.termStatistics));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MtermvectorsResponse._DESERIALIZER);

    public MtermvectorsRequest(Builder builder) {
        this.index = builder.index;
        this.type = builder.type;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.fieldStatistics = builder.fieldStatistics;
        this.offsets = builder.offsets;
        this.payloads = builder.payloads;
        this.positions = builder.positions;
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.routing = builder.routing;
        this.termStatistics = builder.termStatistics;
        this.version = builder.version;
        this.versionType = builder.versionType;
        this.docs = ModelTypeHelper.unmodifiable(builder.docs);
        this.ids = ModelTypeHelper.unmodifiable(builder.ids);
    }

    public MtermvectorsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    @Nullable
    public Boolean offsets() {
        return this.offsets;
    }

    @Nullable
    public Boolean payloads() {
        return this.payloads;
    }

    @Nullable
    public Boolean positions() {
        return this.positions;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public Boolean termStatistics() {
        return this.termStatistics;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public List<Operation> docs() {
        return this.docs;
    }

    @Nullable
    public List<String> ids() {
        return this.ids;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.docs != null) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Operation operation : this.docs) {
                operation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ids != null) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMtermvectorsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(Operation._DESERIALIZER), "docs", new String[0]);
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MtermvectorsRequest> {
        @Nullable
        private String index;
        @Nullable
        private String type;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean fieldStatistics;
        @Nullable
        private Boolean offsets;
        @Nullable
        private Boolean payloads;
        @Nullable
        private Boolean positions;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private String routing;
        @Nullable
        private Boolean termStatistics;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private List<Operation> docs;
        @Nullable
        private List<String> ids;

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder fieldStatistics(@Nullable Boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        public Builder offsets(@Nullable Boolean value) {
            this.offsets = value;
            return this;
        }

        public Builder payloads(@Nullable Boolean value) {
            this.payloads = value;
            return this;
        }

        public Builder positions(@Nullable Boolean value) {
            this.positions = value;
            return this;
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder termStatistics(@Nullable Boolean value) {
            this.termStatistics = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public Builder docs(@Nullable List<Operation> value) {
            this.docs = value;
            return this;
        }

        public Builder docs(Operation ... value) {
            this.docs = Arrays.asList(value);
            return this;
        }

        public Builder addDocs(Operation value) {
            if (this.docs == null) {
                this.docs = new ArrayList<Operation>();
            }
            this.docs.add(value);
            return this;
        }

        public Builder docs(Function<Operation.Builder, ObjectBuilder<Operation>> fn) {
            return this.docs(fn.apply(new Operation.Builder()).build());
        }

        public Builder addDocs(Function<Operation.Builder, ObjectBuilder<Operation>> fn) {
            return this.addDocs(fn.apply(new Operation.Builder()).build());
        }

        public Builder ids(@Nullable List<String> value) {
            this.ids = value;
            return this;
        }

        public Builder ids(String ... value) {
            this.ids = Arrays.asList(value);
            return this;
        }

        public Builder addIds(String value) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            this.ids.add(value);
            return this;
        }

        @Override
        public MtermvectorsRequest build() {
            return new MtermvectorsRequest(this);
        }
    }
}

