/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._core.GetResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetRequest
extends RequestBase {
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> sourceExcludes;
    @Nullable
    private final List<String> sourceIncludes;
    @Nullable
    private final List<String> storedFields;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    private static final SimpleEndpoint<GetRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "GET", request -> {
        boolean _id = true;
        int _index = 2;
        int _type = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.source != null) {
            params.put("_source", JsonpUtils.toString(request.source));
        }
        if (request.sourceExcludes != null) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.sourceIncludes != null) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.storedFields != null) {
            params.put("stored_fields", request.storedFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, null);

    public GetRequest(AbstractBuilder<?> builder) {
        this.id = Objects.requireNonNull(((AbstractBuilder)builder).id, "id");
        this.index = Objects.requireNonNull(((AbstractBuilder)builder).index, "index");
        this.type = ((AbstractBuilder)builder).type;
        this.preference = ((AbstractBuilder)builder).preference;
        this.realtime = ((AbstractBuilder)builder).realtime;
        this.refresh = ((AbstractBuilder)builder).refresh;
        this.routing = ((AbstractBuilder)builder).routing;
        this.source = ((AbstractBuilder)builder).source;
        this.sourceExcludes = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).sourceExcludes);
        this.sourceIncludes = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).sourceIncludes);
        this.storedFields = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).storedFields);
        this.version = ((AbstractBuilder)builder).version;
        this.versionType = ((AbstractBuilder)builder).versionType;
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nullable
    public List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    public static <TDocument> Endpoint<GetRequest, GetResponse<TDocument>, ElasticsearchError> createGetEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(GetResponse.createGetResponseDeserializer(tDocumentDeserializer));
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private String id;
        private String index;
        @Nullable
        private String type;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private Boolean refresh;
        @Nullable
        private String routing;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        protected AbstractBuilder() {
        }

        public BuilderT id(String value) {
            this.id = value;
            return this.self();
        }

        public BuilderT index(String value) {
            this.index = value;
            return this.self();
        }

        public BuilderT type(@Nullable String value) {
            this.type = value;
            return this.self();
        }

        public BuilderT preference(@Nullable String value) {
            this.preference = value;
            return this.self();
        }

        public BuilderT realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this.self();
        }

        public BuilderT refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this.self();
        }

        public BuilderT routing(@Nullable String value) {
            this.routing = value;
            return this.self();
        }

        public BuilderT source(@Nullable JsonValue value) {
            this.source = value;
            return this.self();
        }

        public BuilderT sourceExcludes(@Nullable List<String> value) {
            this.sourceExcludes = value;
            return this.self();
        }

        public BuilderT sourceExcludes(String ... value) {
            this.sourceExcludes = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addSourceExcludes(String value) {
            if (this.sourceExcludes == null) {
                this.sourceExcludes = new ArrayList<String>();
            }
            this.sourceExcludes.add(value);
            return this.self();
        }

        public BuilderT sourceIncludes(@Nullable List<String> value) {
            this.sourceIncludes = value;
            return this.self();
        }

        public BuilderT sourceIncludes(String ... value) {
            this.sourceIncludes = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addSourceIncludes(String value) {
            if (this.sourceIncludes == null) {
                this.sourceIncludes = new ArrayList<String>();
            }
            this.sourceIncludes.add(value);
            return this.self();
        }

        public BuilderT storedFields(@Nullable List<String> value) {
            this.storedFields = value;
            return this.self();
        }

        public BuilderT storedFields(String ... value) {
            this.storedFields = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addStoredFields(String value) {
            if (this.storedFields == null) {
                this.storedFields = new ArrayList<String>();
            }
            this.storedFields.add(value);
            return this.self();
        }

        public BuilderT version(@Nullable Long value) {
            this.version = value;
            return this.self();
        }

        public BuilderT versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<GetRequest> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetRequest build() {
            return new GetRequest(this);
        }
    }
}

