/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.base;

import co.elastic.clients.base.ApiException;
import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchCatRequest;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.Transport;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.NdJsonpSerializable;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;

public class RestClientTransport
implements Transport {
    private final RestClient restClient;
    private final JsonpMapper mapper;
    private RequestOptions requestOptions;

    public RestClientTransport(RestClient restClient, JsonpMapper mapper, @Nullable RequestOptions options) {
        this.restClient = restClient;
        this.mapper = mapper;
        this.requestOptions = options;
    }

    public RestClientTransport(RestClient restClient, JsonpMapper mapper) {
        this(restClient, mapper, null);
    }

    public RestClientTransport withRequestOptions(@Nullable RequestOptions options) {
        return new RestClientTransport(this.restClient, this.mapper, options);
    }

    public RestClientTransport withRequestOptions(Function<RequestOptions.Builder, RequestOptions.Builder> fn) {
        RequestOptions.Builder builder = this.requestOptions == null ? RequestOptions.DEFAULT.toBuilder() : this.requestOptions.toBuilder();
        return this.withRequestOptions(fn.apply(builder).build());
    }

    @Override
    public JsonpMapper jsonpMapper() {
        return this.mapper;
    }

    @Override
    public <RequestT, ResponseT, ErrorT> ResponseT performRequest(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint) throws IOException {
        Request clientReq = this.prepareLowLevelRequest(request, endpoint);
        Response clientResp = this.restClient.performRequest(clientReq);
        return this.getHighLevelResponse(clientResp, endpoint);
    }

    @Override
    public <RequestT, ResponseT, ErrorT> CompletableFuture<ResponseT> performRequestAsync(RequestT request, final Endpoint<RequestT, ResponseT, ErrorT> endpoint) {
        Request clientReq = this.prepareLowLevelRequest(request, endpoint);
        final RequestFuture future = new RequestFuture();
        future.cancellable = this.restClient.performRequestAsync(clientReq, new ResponseListener(){

            public void onSuccess(Response clientResp) {
                try {
                    Object response = RestClientTransport.this.getHighLevelResponse(clientResp, endpoint);
                    future.complete(response);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private <RequestT> Request prepareLowLevelRequest(RequestT request, Endpoint<RequestT, ?, ?> endpoint) {
        String method = endpoint.method(request);
        String path = endpoint.requestUrl(request);
        Map<String, String> params = endpoint.queryParameters(request);
        Request clientReq = new Request(method, path);
        clientReq.addParameters(params);
        if (this.requestOptions != null) {
            clientReq.setOptions(this.requestOptions);
        }
        if (request instanceof ElasticsearchCatRequest) {
            clientReq.addParameter("format", "json");
        }
        if (endpoint.hasRequestBody()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (request instanceof NdJsonpSerializable) {
                this.writeNdJson((NdJsonpSerializable)request, baos);
            } else {
                JsonGenerator generator = this.mapper.jsonProvider().createGenerator((OutputStream)baos);
                this.mapper.serialize(request, generator);
                generator.close();
            }
            clientReq.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray(), ContentType.APPLICATION_JSON));
        }
        clientReq.addParameter("ignore", "400,401,403,404,405");
        return clientReq;
    }

    private void writeNdJson(NdJsonpSerializable<?> value, ByteArrayOutputStream baos) {
        for (Object item : value) {
            if (item instanceof NdJsonpSerializable) {
                this.writeNdJson((NdJsonpSerializable)item, baos);
                continue;
            }
            JsonGenerator generator = this.mapper.jsonProvider().createGenerator((OutputStream)baos);
            this.mapper.serialize(item, generator);
            generator.close();
            baos.write(10);
        }
    }

    private <ResponseT, ErrorT> ResponseT getHighLevelResponse(Response clientResp, Endpoint<?, ResponseT, ErrorT> endpoint) throws IOException {
        int statusCode = clientResp.getStatusLine().getStatusCode();
        if (endpoint.isError(statusCode)) {
            Object error = null;
            JsonpDeserializer<ErrorT> errorParser = endpoint.errorParser(statusCode);
            if (errorParser != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                clientResp.getEntity().writeTo((OutputStream)baos);
                JsonParser parser = this.mapper.jsonProvider().createParser((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                error = errorParser.deserialize(parser, this.mapper);
            }
            throw new ApiException((Object)error);
        }
        if (endpoint instanceof BooleanEndpoint) {
            BooleanEndpoint bep = (BooleanEndpoint)endpoint;
            BooleanResponse response = new BooleanResponse(bep.getResult(statusCode));
            return (ResponseT)response;
        }
        ResponseT response = null;
        JsonpDeserializer<ResponseT> responseParser = endpoint.responseParser();
        if (responseParser != null) {
            InputStream content = clientResp.getEntity().getContent();
            JsonParser parser = this.mapper.jsonProvider().createParser(content);
            response = responseParser.deserialize(parser, this.mapper);
        }
        return response;
    }

    private static class RequestFuture<T>
    extends CompletableFuture<T> {
        private volatile Cancellable cancellable;

        private RequestFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && this.cancellable != null) {
                this.cancellable.cancel();
            }
            return cancelled;
        }
    }
}

