/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ThreadUtil {
    private static final VirtualChecker VIRTUAL_CHECKER = ThreadUtil.generateVirtualChecker();

    public static boolean isVirtual(Thread thread) {
        return VIRTUAL_CHECKER.isVirtual(thread);
    }

    private static VirtualChecker generateVirtualChecker() {
        Method isVirtual = null;
        try {
            isVirtual = Thread.class.getMethod("isVirtual", new Class[0]);
            isVirtual.invoke((Object)Thread.currentThread(), new Object[0]);
            Class impl = new ByteBuddy().subclass(VirtualChecker.class).method((ElementMatcher)ElementMatchers.named((String)"isVirtual")).intercept((Implementation)MethodCall.invoke((Method)isVirtual).onArgument(0)).make().load(VirtualChecker.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            return (VirtualChecker)impl.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return new VirtualChecker(){

                @Override
                public boolean isVirtual(Thread thread) {
                    return false;
                }
            };
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static interface VirtualChecker {
        public boolean isVirtual(Thread var1);
    }
}

