/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.bytebuddy;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;

public class AnnotationValueOffsetMappingFactory
implements Advice.OffsetMapping.Factory<AnnotationValueExtractor> {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationValueOffsetMappingFactory.class);

    public Class<AnnotationValueExtractor> getAnnotationType() {
        return AnnotationValueExtractor.class;
    }

    public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, final AnnotationDescription.Loadable<AnnotationValueExtractor> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
        return new Advice.OffsetMapping(){

            public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
                return Advice.OffsetMapping.Target.ForStackManipulation.of((Object)AnnotationValueOffsetMappingFactory.this.getAnnotationValue(instrumentedMethod, (AnnotationValueExtractor)annotation.load()));
            }
        };
    }

    @Nullable
    private Object getAnnotationValue(MethodDescription instrumentedMethod, AnnotationValueExtractor annotationValueExtractor) {
        ArrayDeque<TypeDescription> typesToCheck = new ArrayDeque<TypeDescription>();
        typesToCheck.add(instrumentedMethod.getDeclaringType().asErasure());
        Set alreadyCheckedTypes = Collections.newSetFromMap(new IdentityHashMap());
        while (!typesToCheck.isEmpty()) {
            AnnotationValue<?, ?> value;
            TypeDescription type = (TypeDescription)typesToCheck.poll();
            if (!alreadyCheckedTypes.add(type)) continue;
            MethodDescription method = this.findMethodWithSameSignature(type, instrumentedMethod);
            if (method != null && (value = AnnotationValueOffsetMappingFactory.findValueOnMethod(method, annotationValueExtractor)) != null) {
                return value.resolve();
            }
            TypeDescription.Generic superClass = type.getSuperClass();
            if (superClass != null) {
                typesToCheck.add(superClass.asErasure());
            }
            for (TypeDescription.Generic interfaceType : type.getInterfaces()) {
                typesToCheck.add(interfaceType.asErasure());
            }
        }
        Class<? extends DefaultValueProvider> defaultValueProvider = annotationValueExtractor.defaultValueProvider();
        try {
            return defaultValueProvider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getDefaultValue();
        }
        catch (Exception e) {
            logger.error(String.format("Failed to obtain default value from %s, used by %s#%s on method %s", defaultValueProvider.getName(), annotationValueExtractor.annotationClassName(), annotationValueExtractor.method(), instrumentedMethod), e);
            return null;
        }
    }

    @Nullable
    private MethodDescription findMethodWithSameSignature(TypeDescription declaringType, MethodDescription instrumentedMethod) {
        for (MethodDescription declaredMethod : declaringType.getDeclaredMethods()) {
            if (!instrumentedMethod.getInternalName().equals(declaredMethod.getInternalName()) || !instrumentedMethod.getParameters().asTypeList().asErasures().equals(declaredMethod.getParameters().asTypeList().asErasures())) continue;
            return declaredMethod;
        }
        return null;
    }

    @Nullable
    private static AnnotationValue<?, ?> findValueOnMethod(MethodDescription method, AnnotationValueExtractor valueExtractor) {
        for (TypeDescription typeDescription : method.getDeclaredAnnotations().asTypeList()) {
            if (!ElementMatchers.named((String)valueExtractor.annotationClassName()).matches((Object)typeDescription)) continue;
            for (MethodDescription.InDefinedShape annotationMethod : typeDescription.getDeclaredMethods()) {
                if (!annotationMethod.getName().equals(valueExtractor.method())) continue;
                return method.getDeclaredAnnotations().ofType(typeDescription).getValue(annotationMethod);
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AnnotationValueExtractor {
        public String annotationClassName();

        public String method();

        public Class<? extends DefaultValueProvider> defaultValueProvider() default NullDefaultValueProvider.class;
    }

    public static interface DefaultValueProvider {
        @Nullable
        public Object getDefaultValue();
    }

    public static class FalseDefaultValueProvider
    implements DefaultValueProvider {
        @Override
        @Nullable
        public Object getDefaultValue() {
            return Boolean.FALSE;
        }
    }

    public static class TrueDefaultValueProvider
    implements DefaultValueProvider {
        @Override
        @Nullable
        public Object getDefaultValue() {
            return Boolean.TRUE;
        }
    }

    public static class NullDefaultValueProvider
    implements DefaultValueProvider {
        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

