/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.internal.util;

import co.elastic.apm.agent.sdk.internal.pooling.ObjectHandle;
import co.elastic.apm.agent.sdk.internal.pooling.ObjectPool;
import co.elastic.apm.agent.sdk.internal.pooling.ObjectPooling;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class IOUtils {
    protected static final int BYTE_BUFFER_CAPACITY = 2048;
    private static final ObjectPool<? extends ObjectHandle<ByteBuffer>> BYTE_BUFFER_POOL = ObjectPooling.createWithDefaultFactory(new Callable<ByteBuffer>(){

        @Override
        public ByteBuffer call() throws Exception {
            return ByteBuffer.allocate(2048);
        }
    });
    private static final Set<String> UNSUPPORTED_CHARSETS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, ObjectPool<? extends ObjectHandle<CharsetDecoder>>> DECODER_POOLS = new ConcurrentHashMap<String, ObjectPool<? extends ObjectHandle<CharsetDecoder>>>();
    private static final String UTF8_CHARSET_NAME = StandardCharsets.UTF_8.name().toLowerCase();

    @Nullable
    private static ObjectHandle<CharsetDecoder> getPooledCharsetDecoder(String charsetName) {
        ObjectPool<ObjectHandle<CharsetDecoder>> decoderPool;
        if (!IOUtils.isLowerCase(charsetName)) {
            charsetName = charsetName.toLowerCase();
        }
        if ((decoderPool = DECODER_POOLS.get(charsetName)) != null) {
            return decoderPool.createInstance();
        }
        if (UNSUPPORTED_CHARSETS.contains(charsetName)) {
            return null;
        }
        try {
            final Charset charset = Charset.forName(charsetName);
            decoderPool = ObjectPooling.createWithDefaultFactory(new Callable<CharsetDecoder>(){

                @Override
                public CharsetDecoder call() throws Exception {
                    return charset.newDecoder();
                }
            });
            DECODER_POOLS.put(charsetName, decoderPool);
            return decoderPool.createInstance();
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            UNSUPPORTED_CHARSETS.add(charsetName);
            return null;
        }
    }

    private static boolean isLowerCase(String charsetName) {
        for (int i = 0; i < charsetName.length(); ++i) {
            if (Character.isLowerCase(charsetName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static boolean readUtf8Stream(InputStream is, CharBuffer charBuffer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, CharBuffer charBuffer) {
        return IOUtils.decodeUtf8Bytes(bytes, 0, bytes.length, charBuffer);
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, int offset, int length, CharBuffer charBuffer) {
        try (ObjectHandle<ByteBuffer> bufferHandle = BYTE_BUFFER_POOL.createInstance();){
            ObjectHandle<CharsetDecoder> decoderHandle = IOUtils.getPooledCharsetDecoder(UTF8_CHARSET_NAME);
            try {
                ByteBuffer buffer;
                ByteBuffer pooledBuffer = bufferHandle.get();
                if (pooledBuffer.capacity() < length) {
                    buffer = ByteBuffer.wrap(bytes, offset, length);
                } else {
                    buffer = pooledBuffer;
                    buffer.put(bytes, offset, length);
                    ((Buffer)buffer).position(0);
                    ((Buffer)buffer).limit(length);
                }
                CoderResult coderResult = IOUtils.decode(charBuffer, buffer, decoderHandle.get());
                if (decoderHandle != null) {
                    decoderHandle.close();
                }
                return coderResult;
            }
            catch (Throwable throwable) {
                if (decoderHandle != null) {
                    try {
                        decoderHandle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static CoderResult decodeUtf8Byte(byte b, CharBuffer charBuffer) {
        try (ObjectHandle<ByteBuffer> bufferHandle = BYTE_BUFFER_POOL.createInstance();){
            ObjectHandle<CharsetDecoder> decoderHandle = IOUtils.getPooledCharsetDecoder(UTF8_CHARSET_NAME);
            try {
                ByteBuffer buffer = bufferHandle.get();
                buffer.put(b);
                ((Buffer)buffer).position(0);
                ((Buffer)buffer).limit(1);
                CoderResult coderResult = IOUtils.decode(charBuffer, buffer, decoderHandle.get());
                if (decoderHandle != null) {
                    decoderHandle.close();
                }
                return coderResult;
            }
            catch (Throwable throwable) {
                if (decoderHandle != null) {
                    try {
                        decoderHandle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> CoderResult decodeUtf8BytesFromSource(ByteSourceReader<T> reader, T src, CharBuffer dest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static byte[] copyToByteArray(List<ByteBuffer> buffers) {
        int totalSize = 0;
        for (ByteBuffer buff : buffers) {
            totalSize += buff.position();
        }
        byte[] data = new byte[totalSize];
        int off = 0;
        for (ByteBuffer buff : buffers) {
            int len = buff.position();
            buff.position(0);
            buff.get(data, off, len);
            off += len;
        }
        return data;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CoderResult decode(List<ByteBuffer> input, CharBuffer output, String charsetName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CoderResult decode(CharBuffer charBuffer, ByteBuffer buffer, CharsetDecoder charsetDecoder) {
        try {
            CoderResult coderResult = charsetDecoder.decode(buffer, charBuffer, true);
            charsetDecoder.flush(charBuffer);
            CoderResult coderResult2 = coderResult;
            return coderResult2;
        }
        finally {
            ((Buffer)buffer).clear();
            charsetDecoder.reset();
        }
    }

    public static interface ByteSourceReader<S> {
        public int availableBytes(S var1);

        public void readInto(S var1, ByteBuffer var2);
    }
}

