/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.bytebuddy;

public class ClassNameParser {
    private ClassNameParser() {
    }

    private static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String getAnonymousClassName(String className) {
        String nestedClassName;
        int currentDollarIndex;
        int lastDollarIndex = className.lastIndexOf(36);
        do {
            currentDollarIndex = className.lastIndexOf(36, lastDollarIndex - 1);
            nestedClassName = className.substring(currentDollarIndex + 1, lastDollarIndex);
            lastDollarIndex = currentDollarIndex;
        } while (currentDollarIndex != -1 && ClassNameParser.isNumeric(nestedClassName));
        return className.substring(currentDollarIndex + 1);
    }

    private static String getNestedClassName(String className) {
        int dollarIndex = className.lastIndexOf(36);
        String innerClassName = className.substring(dollarIndex + 1);
        className = ClassNameParser.isNumeric(innerClassName) ? ClassNameParser.getAnonymousClassName(className) : innerClassName;
        return className;
    }

    public static String parse(String className) {
        if ((className = className.substring(className.lastIndexOf(46) + 1)).contains("$")) {
            if (className.endsWith("$")) {
                if ((className = className.substring(0, className.length() - 1)).contains("$")) {
                    className = ClassNameParser.getNestedClassName(className);
                }
            } else {
                className = ClassNameParser.getNestedClassName(className);
            }
        }
        return className;
    }
}

