/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.weakconcurrent;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.lang.ref.SoftReference;
import javax.annotation.Nullable;

public class WeakKeySoftValueLoadingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(WeakKeySoftValueLoadingCache.class);
    private final WeakMap<K, CacheValue<K, V>> cache = WeakConcurrent.buildMap();
    private final ValueSupplier<K, V> valueSupplier;

    public WeakKeySoftValueLoadingCache(ValueSupplier<K, V> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    @Nullable
    public V get(K key) {
        CacheValue<K, V> cacheValue = this.cache.get(key);
        if (cacheValue != null) {
            return cacheValue.get(key);
        }
        CacheValue value = new CacheValue(key, this.valueSupplier);
        this.cache.put(key, value);
        return value.get(key);
    }

    public static interface ValueSupplier<K, V> {
        @Nullable
        public V get(K var1);
    }

    private static class CacheValue<K, V> {
        private final ValueSupplier<K, V> valueSupplier;
        @Nullable
        private SoftReference<V> valueReference;

        private CacheValue(K key, ValueSupplier<K, V> valueSupplier) {
            this.valueSupplier = valueSupplier;
            V value = valueSupplier.get(key);
            if (value != null) {
                this.valueReference = new SoftReference<V>(value);
            }
        }

        @Nullable
        public V get(K key) {
            if (this.valueReference == null) {
                return null;
            }
            V value = this.valueReference.get();
            if (value != null) {
                return value;
            }
            logger.info("The value for the key {} has been collected, reloading it", (Object)key);
            value = this.valueSupplier.get(key);
            this.valueReference = new SoftReference<V>(value);
            return value;
        }
    }
}

