/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.internal.util;

import co.elastic.apm.agent.sdk.internal.pooling.ObjectHandle;
import co.elastic.apm.agent.sdk.internal.pooling.ObjectPool;
import co.elastic.apm.agent.sdk.internal.pooling.ObjectPooling;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;

public class IOUtils {
    protected static final int BYTE_BUFFER_CAPACITY = 2048;
    private static final ObjectPool<? extends ObjectHandle<DecoderWithBuffer>> POOL = ObjectPooling.createWithDefaultFactory(new Callable<DecoderWithBuffer>(){

        @Override
        public DecoderWithBuffer call() throws Exception {
            return new DecoderWithBuffer();
        }
    });

    /*
     * Exception decompiling
     */
    public static boolean readUtf8Stream(InputStream is, CharBuffer charBuffer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, CharBuffer charBuffer) {
        return IOUtils.decodeUtf8Bytes(bytes, 0, bytes.length, charBuffer);
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, int offset, int length, CharBuffer charBuffer) {
        try (ObjectHandle<DecoderWithBuffer> pooled = POOL.createInstance();){
            ByteBuffer buffer;
            ByteBuffer pooledBuffer = pooled.get().byteBuffer;
            CharsetDecoder charsetDecoder = pooled.get().decoder;
            if (pooledBuffer.capacity() < length) {
                buffer = ByteBuffer.wrap(bytes, offset, length);
            } else {
                buffer = pooledBuffer;
                buffer.put(bytes, offset, length);
                ((Buffer)buffer).position(0);
                ((Buffer)buffer).limit(length);
            }
            CoderResult coderResult = IOUtils.decode(charBuffer, buffer, charsetDecoder);
            return coderResult;
        }
    }

    public static CoderResult decodeUtf8Byte(byte b, CharBuffer charBuffer) {
        try (ObjectHandle<DecoderWithBuffer> pooled = POOL.createInstance();){
            ByteBuffer buffer = pooled.get().byteBuffer;
            CharsetDecoder charsetDecoder = pooled.get().decoder;
            buffer.put(b);
            ((Buffer)buffer).position(0);
            ((Buffer)buffer).limit(1);
            CoderResult coderResult = IOUtils.decode(charBuffer, buffer, charsetDecoder);
            return coderResult;
        }
    }

    public static <T> CoderResult decodeUtf8BytesFromSource(ByteSourceReader<T> reader, T src, CharBuffer dest) {
        try (ObjectHandle<DecoderWithBuffer> pooled = POOL.createInstance();){
            ByteBuffer buffer = pooled.get().byteBuffer;
            CharsetDecoder charsetDecoder = pooled.get().decoder;
            int readableBytes = reader.availableBytes(src);
            CoderResult result = null;
            while (readableBytes > 0) {
                int length = Math.min(readableBytes, 2048);
                ((Buffer)buffer).limit(length);
                ((Buffer)buffer).position(0);
                reader.readInto(src, buffer);
                ((Buffer)buffer).position(0);
                result = IOUtils.decode(dest, buffer, charsetDecoder);
                if (result.isError() || result.isOverflow()) {
                    CoderResult coderResult = result;
                    return coderResult;
                }
                readableBytes = reader.availableBytes(src);
            }
            CoderResult coderResult = result == null ? CoderResult.OVERFLOW : result;
            return coderResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CoderResult decode(CharBuffer charBuffer, ByteBuffer buffer, CharsetDecoder charsetDecoder) {
        try {
            CoderResult coderResult = charsetDecoder.decode(buffer, charBuffer, true);
            charsetDecoder.flush(charBuffer);
            CoderResult coderResult2 = coderResult;
            return coderResult2;
        }
        finally {
            ((Buffer)buffer).clear();
            charsetDecoder.reset();
        }
    }

    private static class DecoderWithBuffer {
        final ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();

        private DecoderWithBuffer() {
        }
    }

    public static interface ByteSourceReader<S> {
        public int availableBytes(S var1);

        public void readInto(S var1, ByteBuffer var2);
    }
}

