/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.internal.db.signature;

import co.elastic.apm.agent.sdk.internal.collections.LRUCache;
import co.elastic.apm.agent.sdk.internal.db.signature.Scanner;
import co.elastic.apm.agent.sdk.internal.pooling.ObjectHandle;
import co.elastic.apm.agent.sdk.internal.pooling.ObjectPool;
import co.elastic.apm.agent.sdk.internal.pooling.ObjectPooling;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class SignatureParser {
    private final ObjectPool<? extends ObjectHandle<Scanner>> scannerPool;
    private final Map<String, String[]> signatureCache = LRUCache.createCache(1000);

    public SignatureParser() {
        this(new Callable<Scanner>(){

            @Override
            public Scanner call() {
                return new Scanner();
            }
        });
    }

    public SignatureParser(Callable<Scanner> scannerAllocator) {
        this.scannerPool = ObjectPooling.createWithDefaultFactory(scannerAllocator);
    }

    public void querySignature(String query, StringBuilder signature, boolean preparedStatement) {
        this.querySignature(query, signature, null, preparedStatement);
    }

    public void querySignature(String query, StringBuilder signature, @Nullable StringBuilder dbLink, boolean preparedStatement) {
        String[] cachedSignature = this.signatureCache.get(query);
        if (cachedSignature != null) {
            signature.append(cachedSignature[0]);
            if (dbLink != null) {
                dbLink.append(cachedSignature[1]);
            }
            return;
        }
        try (ObjectHandle<Scanner> pooledScanner = this.scannerPool.createInstance();){
            Scanner scanner = pooledScanner.get();
            scanner.setQuery(query);
            this.parse(scanner, query, signature, dbLink);
            this.signatureCache.put(query, new String[]{signature.toString(), dbLink != null ? dbLink.toString() : ""});
        }
    }

    private void parse(Scanner scanner, String query, StringBuilder signature, @Nullable StringBuilder dbLink) {
        Scanner.Token firstToken = scanner.scanWhile(Scanner.Token.COMMENT);
        switch (firstToken) {
            case CALL: {
                signature.append("CALL");
                if (scanner.scanUntil(Scanner.Token.IDENT)) {
                    this.appendIdentifiers(scanner, signature, dbLink);
                }
                return;
            }
            case DELETE: {
                signature.append("DELETE");
                if (scanner.scanUntil(Scanner.Token.FROM) && scanner.scanUntil(Scanner.Token.IDENT)) {
                    signature.append(" FROM");
                    this.appendIdentifiers(scanner, signature, dbLink);
                }
                return;
            }
            case INSERT: 
            case REPLACE: {
                signature.append(firstToken.name());
                if (scanner.scanUntil(Scanner.Token.INTO) && scanner.scanUntil(Scanner.Token.IDENT)) {
                    signature.append(" INTO");
                    this.appendIdentifiers(scanner, signature, dbLink);
                }
                return;
            }
            case SELECT: {
                signature.append("SELECT");
                int level = 0;
                Scanner.Token t = scanner.scan();
                while (t != Scanner.Token.EOF) {
                    if (t == Scanner.Token.LPAREN) {
                        ++level;
                    } else if (t == Scanner.Token.RPAREN) {
                        --level;
                    } else if (t == Scanner.Token.FROM && level == 0) {
                        if (scanner.scanToken(Scanner.Token.IDENT)) {
                            signature.append(" FROM");
                            this.appendIdentifiers(scanner, signature, dbLink);
                        } else {
                            return;
                        }
                    }
                    t = scanner.scan();
                }
                return;
            }
            case UPDATE: {
                signature.append("UPDATE");
                boolean hasPeriod = false;
                boolean hasFirstPeriod = false;
                boolean isDbLink = false;
                if (scanner.scanToken(Scanner.Token.IDENT)) {
                    signature.append(' ');
                    scanner.appendCurrentTokenText(signature);
                    Scanner.Token t = scanner.scan();
                    while (t != Scanner.Token.EOF) {
                        switch (t) {
                            case IDENT: {
                                if (hasPeriod) {
                                    scanner.appendCurrentTokenText(signature);
                                    hasPeriod = false;
                                }
                                if (!hasFirstPeriod) {
                                    signature.setLength(0);
                                    signature.append("UPDATE ");
                                    scanner.appendCurrentTokenText(signature);
                                    break;
                                }
                                if (!isDbLink) break;
                                if (dbLink != null) {
                                    scanner.appendCurrentTokenText(dbLink);
                                }
                                isDbLink = false;
                                break;
                            }
                            case PERIOD: {
                                hasFirstPeriod = true;
                                hasPeriod = true;
                                signature.append('.');
                                break;
                            }
                            default: {
                                if ("@".equals(scanner.text())) {
                                    isDbLink = true;
                                    break;
                                }
                                return;
                            }
                        }
                        t = scanner.scan();
                    }
                }
                return;
            }
            case MERGE: {
                signature.append("MERGE");
                if (scanner.scanToken(Scanner.Token.INTO) && scanner.scanUntil(Scanner.Token.IDENT)) {
                    signature.append(" INTO");
                    this.appendIdentifiers(scanner, signature, dbLink);
                }
                return;
            }
        }
        query = query.trim();
        int indexOfWhitespace = query.indexOf(32);
        signature.append(query, 0, indexOfWhitespace > 0 ? indexOfWhitespace : query.length());
    }

    private void appendIdentifiers(Scanner scanner, StringBuilder signature, @Nullable StringBuilder dbLink) {
        signature.append(' ');
        scanner.appendCurrentTokenText(signature);
        boolean connectedIdents = false;
        boolean isDbLink = false;
        Scanner.Token t = scanner.scan();
        while (t != Scanner.Token.EOF) {
            switch (t) {
                case IDENT: {
                    if (connectedIdents) {
                        scanner.appendCurrentTokenText(signature);
                        connectedIdents = false;
                        break;
                    }
                    if (isDbLink && dbLink != null) {
                        scanner.appendCurrentTokenText(dbLink);
                    }
                    return;
                }
                case PERIOD: {
                    signature.append('.');
                    connectedIdents = true;
                    break;
                }
                case USING: {
                    return;
                }
                default: {
                    if (!"@".equals(scanner.text())) break;
                    isDbLink = true;
                }
            }
            t = scanner.scan();
        }
    }
}

