/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.internal.util;

import co.elastic.apm.agent.sdk.logging.Logger;
import java.util.concurrent.atomic.AtomicBoolean;

public class LoggerUtils {
    public static Logger logOnce(Logger logger) {
        return new LogOnceLogger(logger);
    }

    private static class LogOnceLogger
    implements Logger {
        private final Logger delegate;
        private final AtomicBoolean alreadyLogged = new AtomicBoolean(false);

        private LogOnceLogger(Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        private boolean isEnabled(boolean delegateEnabled) {
            if (this.alreadyLogged.get()) {
                return false;
            }
            return delegateEnabled;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isEnabled(this.delegate.isTraceEnabled());
        }

        @Override
        public void trace(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(msg);
            }
        }

        @Override
        public void trace(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(format, arg);
            }
        }

        @Override
        public void trace(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(format, arg1, arg2);
            }
        }

        @Override
        public void trace(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(format, arguments);
            }
        }

        @Override
        public void trace(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.trace(msg, t);
            }
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isEnabled(this.delegate.isDebugEnabled());
        }

        @Override
        public void debug(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(msg);
            }
        }

        @Override
        public void debug(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(format, arg);
            }
        }

        @Override
        public void debug(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(format, arg1, arg2);
            }
        }

        @Override
        public void debug(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(format, arguments);
            }
        }

        @Override
        public void debug(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.debug(msg, t);
            }
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isEnabled(this.delegate.isInfoEnabled());
        }

        @Override
        public void info(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(msg);
            }
        }

        @Override
        public void info(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(format, arg);
            }
        }

        @Override
        public void info(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(format, arg1, arg2);
            }
        }

        @Override
        public void info(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(format, arguments);
            }
        }

        @Override
        public void info(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.info(msg, t);
            }
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isEnabled(this.delegate.isWarnEnabled());
        }

        @Override
        public void warn(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(msg);
            }
        }

        @Override
        public void warn(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(format, arg);
            }
        }

        @Override
        public void warn(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(format, arguments);
            }
        }

        @Override
        public void warn(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(format, arg1, arg2);
            }
        }

        @Override
        public void warn(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.warn(msg, t);
            }
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isEnabled(this.delegate.isErrorEnabled());
        }

        @Override
        public void error(String msg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(msg);
            }
        }

        @Override
        public void error(String format, Object arg) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(format, arg);
            }
        }

        @Override
        public void error(String format, Object arg1, Object arg2) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(format, arg1, arg2);
            }
        }

        @Override
        public void error(String format, Object ... arguments) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(format, arguments);
            }
        }

        @Override
        public void error(String msg, Throwable t) {
            if (this.alreadyLogged.compareAndSet(false, true)) {
                this.delegate.error(msg, t);
            }
        }
    }
}

