/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import javax.annotation.Nullable;

public class InternalUtil {
    public static <T> T getServiceProvider(final Class<T> serviceInterface) {
        if (System.getSecurityManager() == null) {
            return InternalUtil.internalGetServiceProvider(serviceInterface);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            @Nullable
            public T run() {
                return InternalUtil.internalGetServiceProvider(serviceInterface);
            }
        });
    }

    private static <T> T internalGetServiceProvider(Class<T> serviceInterface) {
        ClassLoader classLoader = serviceInterface.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ServiceLoader.load(serviceInterface, classLoader).iterator().next();
    }
}

