/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.logging;

import co.elastic.apm.agent.sdk.logging.ILoggerFactory;
import co.elastic.apm.agent.sdk.logging.Logger;

public class LoggerFactory {
    private static volatile ILoggerFactory iLoggerFactory;

    public static void initialize(ILoggerFactory iLoggerFactory) {
        LoggerFactory.iLoggerFactory = iLoggerFactory;
    }

    public static Logger getLogger(String name) {
        if (iLoggerFactory == null) {
            return NoopLogger.INSTANCE;
        }
        return iLoggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    private static class NoopLogger
    implements Logger {
        static final NoopLogger INSTANCE = new NoopLogger();

        private NoopLogger() {
        }

        @Override
        public String getName() {
            return "null";
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public void trace(String msg) {
        }

        @Override
        public void trace(String format, Object arg) {
        }

        @Override
        public void trace(String format, Object arg1, Object arg2) {
        }

        @Override
        public void trace(String format, Object ... arguments) {
        }

        @Override
        public void trace(String msg, Throwable t) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void debug(String format, Object arg) {
        }

        @Override
        public void debug(String format, Object arg1, Object arg2) {
        }

        @Override
        public void debug(String format, Object ... arguments) {
        }

        @Override
        public void debug(String msg, Throwable t) {
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public void info(String msg) {
        }

        @Override
        public void info(String format, Object arg) {
        }

        @Override
        public void info(String format, Object arg1, Object arg2) {
        }

        @Override
        public void info(String format, Object ... arguments) {
        }

        @Override
        public void info(String msg, Throwable t) {
        }

        @Override
        public boolean isWarnEnabled() {
            return false;
        }

        @Override
        public void warn(String msg) {
        }

        @Override
        public void warn(String format, Object arg) {
        }

        @Override
        public void warn(String format, Object ... arguments) {
        }

        @Override
        public void warn(String format, Object arg1, Object arg2) {
        }

        @Override
        public void warn(String msg, Throwable t) {
        }

        @Override
        public boolean isErrorEnabled() {
            return false;
        }

        @Override
        public void error(String msg) {
        }

        @Override
        public void error(String format, Object arg) {
        }

        @Override
        public void error(String format, Object arg1, Object arg2) {
        }

        @Override
        public void error(String format, Object ... arguments) {
        }

        @Override
        public void error(String msg, Throwable t) {
        }
    }
}

