/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sdk.weakmap;

import co.elastic.apm.agent.sdk.weakmap.NullCheck;
import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import javax.annotation.Nullable;

public class NullSafeWeakConcurrentMap<K, V>
extends WeakConcurrentMap<K, V> {
    public NullSafeWeakConcurrentMap(boolean cleanerThread) {
        super(cleanerThread);
    }

    @Nullable
    public V get(K key) {
        if (NullCheck.isNullKey(key)) {
            return null;
        }
        return (V)super.get(key);
    }

    @Nullable
    public V getIfPresent(K key) {
        if (NullCheck.isNullKey(key)) {
            return null;
        }
        return (V)super.getIfPresent(key);
    }

    public boolean containsKey(K key) {
        if (NullCheck.isNullKey(key)) {
            return false;
        }
        return super.containsKey(key);
    }

    @Nullable
    public V put(K key, V value) {
        if (NullCheck.isNullKey(key) || NullCheck.isNullValue(value)) {
            return null;
        }
        return (V)super.put(key, value);
    }

    @Nullable
    public V putIfAbsent(K key, V value) {
        if (NullCheck.isNullKey(key) || NullCheck.isNullValue(value)) {
            return null;
        }
        return (V)super.putIfAbsent(key, value);
    }

    @Nullable
    public V putIfProbablyAbsent(K key, V value) {
        if (NullCheck.isNullKey(key) || NullCheck.isNullValue(value)) {
            return null;
        }
        return (V)super.putIfProbablyAbsent(key, value);
    }

    @Nullable
    public V remove(K key) {
        if (NullCheck.isNullKey(key)) {
            return null;
        }
        return (V)super.remove(key);
    }
}

