/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.common.util;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ProcessExecutionUtil {
    public static CommandOutput executeCommand(List<String> command) {
        return ProcessExecutionUtil.executeCommand(command, TimeUnit.SECONDS.toMillis(5L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandOutput executeCommand(List<String> command, long timeoutMillis) {
        ProcessBuilder buildTheProcess = new ProcessBuilder(command);
        buildTheProcess.redirectErrorStream(true);
        Process spawnedProcess = null;
        int exitValue = -1;
        Throwable exception = null;
        StringBuilder commandOutput = new StringBuilder();
        long duration = 0L;
        try {
            spawnedProcess = buildTheProcess.start();
            long start = System.currentTimeMillis();
            boolean isAlive = true;
            byte[] buffer = new byte[4000];
            try (InputStream in = spawnedProcess.getInputStream();){
                while (isAlive && duration < timeoutMillis) {
                    while (in.available() > 0) {
                        int lengthRead = in.read(buffer, 0, buffer.length);
                        commandOutput.append(new String(buffer, 0, lengthRead));
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException lengthRead) {
                        // empty catch block
                    }
                    duration = System.currentTimeMillis() - start;
                    isAlive = ProcessExecutionUtil.processIsAlive(spawnedProcess) || in.available() > 0;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException lengthRead) {
                    // empty catch block
                }
                if (duration >= timeoutMillis) {
                    spawnedProcess.destroy();
                    throw new TimeoutException(String.format("Execution of %s exceeded the specified timeout of %sms. Process killed.", ProcessExecutionUtil.cmdAsString(command), timeoutMillis));
                }
                while (in.available() > 0) {
                    int lengthRead = in.read(buffer, 0, buffer.length);
                    commandOutput.append(new String(buffer, 0, lengthRead));
                }
            }
        }
        catch (Throwable e1) {
            exception = e1;
        }
        finally {
            block34: {
                if (spawnedProcess != null && ProcessExecutionUtil.processIsAlive(spawnedProcess)) {
                    spawnedProcess.destroy();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException start) {}
                }
                if (spawnedProcess != null) {
                    try {
                        exitValue = spawnedProcess.exitValue();
                    }
                    catch (IllegalThreadStateException e2) {
                        if (exception != null) break block34;
                        exception = e2;
                    }
                }
            }
        }
        return new CommandOutput(commandOutput, exitValue, exception, duration);
    }

    public static boolean processIsAlive(Process proc) {
        try {
            proc.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public static String cmdAsString(List<String> cmd) {
        StringBuilder cmdToString = new StringBuilder("\"");
        int i = 0;
        while (i < cmd.size()) {
            cmdToString.append(cmd.get(i));
            if (++i >= cmd.size()) continue;
            cmdToString.append(" ");
        }
        cmdToString.append("\"");
        return cmdToString.toString();
    }

    public static class CommandOutput {
        StringBuilder output;
        int exitCode;
        Throwable exceptionThrown;
        long timeTakenInMilliseconds;

        public CommandOutput(StringBuilder output, int exitCode, Throwable exception, long time) {
            this.output = output;
            this.exitCode = exitCode;
            this.exceptionThrown = exception;
            this.timeTakenInMilliseconds = time;
        }

        public long getTimeTakenInMilliseconds() {
            return this.timeTakenInMilliseconds;
        }

        public StringBuilder getOutput() {
            return this.output;
        }

        public boolean exitedNormally() {
            return this.getExceptionThrown() == null && this.exitCode == 0;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public Throwable getExceptionThrown() {
            return this.exceptionThrown;
        }

        public String toString() {
            if (this.exceptionThrown != null) {
                return "Exit Code: " + this.exitCode + "; Time: " + this.timeTakenInMilliseconds + "ms; Output: " + this.output.toString() + "\r\nException: " + this.exceptionThrown;
            }
            return "Exit Code: " + this.exitCode + "; Time: " + this.timeTakenInMilliseconds + "ms; Output: " + this.output.toString();
        }
    }
}

