/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.bytebuddy.agent.ByteBuddyAgent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ElasticApmAttacher {
    public static void attach() {
        ByteBuddyAgent.attach(AgentJarFileHolder.INSTANCE.agentJarFile, ByteBuddyAgent.ProcessProvider.ForCurrentVm.INSTANCE);
    }

    public static void attach(String pid, String agentArgs) {
        ByteBuddyAgent.attach(AgentJarFileHolder.INSTANCE.agentJarFile, pid, agentArgs);
    }

    private static enum AgentJarFileHolder {
        INSTANCE;

        final File agentJarFile = AgentJarFileHolder.getAgentJarFile();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static File getAgentJarFile() {
            try (InputStream agentJar = ElasticApmAttacher.class.getResourceAsStream("/elastic-apm-agent.jar");){
                if (agentJar == null) {
                    throw new IllegalStateException("Agent jar not found");
                }
                File tempAgentJar = File.createTempFile("elastic-apm-agent", ".jar");
                try (FileOutputStream out = new FileOutputStream(tempAgentJar);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = agentJar.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, length);
                    }
                }
                File file = tempAgentJar;
                return file;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

