/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.JvmInfo;
import co.elastic.apm.attach.RemoteAttacher;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public interface JvmDiscoverer {
    public Collection<JvmInfo> discoverJvms() throws Exception;

    public boolean isAvailable();

    public static class ForHotSpotVm
    implements JvmDiscoverer {
        private final String tempDir;

        public ForHotSpotVm(String tempDir) {
            this.tempDir = tempDir;
        }

        public static ForHotSpotVm withDefaultTempDir() {
            String temporaryDirectory;
            if (Platform.isMac()) {
                temporaryDirectory = System.getenv("TMPDIR");
                if (temporaryDirectory == null) {
                    temporaryDirectory = "/tmp";
                }
            } else if (Platform.isWindows()) {
                temporaryDirectory = System.getenv("TEMP");
                if (temporaryDirectory == null) {
                    temporaryDirectory = "c:/Temp";
                }
            } else {
                temporaryDirectory = "/tmp";
            }
            return new ForHotSpotVm(temporaryDirectory);
        }

        @Override
        public Collection<JvmInfo> discoverJvms() {
            ArrayList<JvmInfo> result = new ArrayList<JvmInfo>();
            File[] hsPerfdataFolders = this.getHsPerfdataFolders();
            if (hsPerfdataFolders != null) {
                for (File hsPerfdataFolder : hsPerfdataFolders) {
                    File[] jvmPidFiles = hsPerfdataFolder.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isFile() && file.canRead() && file.getName().matches("\\d+");
                        }
                    });
                    if (jvmPidFiles == null) continue;
                    for (File jvmPidFile : jvmPidFiles) {
                        result.add(new JvmInfo(jvmPidFile.getName(), null));
                    }
                }
            }
            return result;
        }

        @Override
        public boolean isAvailable() {
            File[] files = this.getHsPerfdataFolders();
            return files != null && files.length > 0;
        }

        private File[] getHsPerfdataFolders() {
            return new File(this.tempDir).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("hsperfdata_");
                }
            });
        }
    }

    public static enum Unavailable implements JvmDiscoverer
    {
        INSTANCE;


        @Override
        public Collection<JvmInfo> discoverJvms() {
            throw new IllegalStateException("Can't discover JVMs for this platform");
        }

        @Override
        public boolean isAvailable() {
            return false;
        }
    }

    public static enum Jps implements JvmDiscoverer
    {
        INSTANCE;


        @Nonnull
        private static String getJpsOutput() throws IOException, InterruptedException {
            Process jps = new ProcessBuilder("jps", "-lv").start();
            if (jps.waitFor() == 0) {
                return RemoteAttacher.toString(jps.getInputStream());
            }
            throw new IllegalStateException(RemoteAttacher.toString(jps.getErrorStream()));
        }

        @Override
        public Collection<JvmInfo> discoverJvms() throws Exception {
            return this.getJVMs(Jps.getJpsOutput());
        }

        @Nonnull
        private Set<JvmInfo> getJVMs(String jpsOutput) {
            HashSet<JvmInfo> set = new HashSet<JvmInfo>();
            for (String s : jpsOutput.split("\n")) {
                JvmInfo parse = JvmInfo.parse(s);
                set.add(parse);
            }
            return set;
        }

        @Override
        public boolean isAvailable() {
            try {
                return new ProcessBuilder("jps", "-lv").start().waitFor() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static enum ForCurrentVM implements JvmDiscoverer
    {
        INSTANCE;

        private final JvmDiscoverer delegate;

        private ForCurrentVM() {
            JvmDiscoverer tempJvmDiscoverer = Unavailable.INSTANCE;
            for (JvmDiscoverer jvmDiscoverer : Arrays.asList(Jps.INSTANCE, ForHotSpotVm.withDefaultTempDir())) {
                if (jvmDiscoverer.isAvailable()) {
                    tempJvmDiscoverer = jvmDiscoverer;
                    break;
                }
                System.out.println(jvmDiscoverer.getClass().getSimpleName() + " is not available");
            }
            this.delegate = tempJvmDiscoverer;
        }

        @Override
        public Collection<JvmInfo> discoverJvms() throws Exception {
            return this.delegate.discoverJvms();
        }

        @Override
        public boolean isAvailable() {
            return this.delegate.isAvailable();
        }
    }
}

