/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j2;

import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.JsonUtils;
import co.elastic.logging.log4j2.MdcSerializer;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.util.TriConsumer;

interface DefaultMdcSerializer
extends MdcSerializer {

    public static enum UsingContextMap implements MdcSerializer
    {
        INSTANCE;


        @Override
        public void serializeMdc(LogEvent event, StringBuilder builder) {
            EcsJsonSerializer.serializeMDC(builder, event.getContextMap());
        }
    }

    public static enum UsingContextData implements MdcSerializer
    {
        INSTANCE;

        private static final TriConsumer<String, Object, StringBuilder> WRITE_MDC;

        @Override
        public void serializeMdc(LogEvent event, StringBuilder builder) {
            event.getContextData().forEach(WRITE_MDC, builder);
        }

        static {
            WRITE_MDC = new TriConsumer<String, Object, StringBuilder>(){

                @Override
                public void accept(String key, Object value, StringBuilder stringBuilder) {
                    stringBuilder.append('\"');
                    JsonUtils.quoteAsString(key, stringBuilder);
                    stringBuilder.append("\":\"");
                    JsonUtils.quoteAsString(EcsJsonSerializer.toNullSafeString(String.valueOf(value)), stringBuilder);
                    stringBuilder.append("\",");
                }
            };
        }
    }
}

