/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.ElasticAttachmentProvider;
import co.elastic.apm.attach.bytebuddy.agent.ByteBuddyAgent;
import java.util.Map;
import java.util.Properties;

public class JvmAttachUtils {
    public static final String CURRENT_PID = ByteBuddyAgent.ProcessProvider.ForCurrentVm.INSTANCE.resolve();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getAgentAndSystemProperties(String pid) {
        Properties properties;
        ByteBuddyAgent.AttachmentProvider.Accessor accessor = ElasticAttachmentProvider.get().attempt();
        if (!accessor.isAvailable()) {
            throw new IllegalStateException("No compatible attachment provider is available");
        }
        Class<?> vm = accessor.getVirtualMachineType();
        Object virtualMachineInstance = vm.getMethod("attach", String.class).invoke(null, pid);
        try {
            Properties agentProperties = (Properties)vm.getMethod("getAgentProperties", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
            Properties systemProperties = (Properties)vm.getMethod("getSystemProperties", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
            systemProperties.putAll((Map<?, ?>)agentProperties);
            properties = systemProperties;
        }
        catch (Throwable throwable) {
            try {
                vm.getMethod("detach", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error during attachment using: " + accessor, e);
            }
        }
        vm.getMethod("detach", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
        return properties;
    }
}

