/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.UserRegistry;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;

public class AgentDownloadUtils {
    private static final String AGENT_BASE_DIR = "agent";
    private static final ConcurrentHashMap<String, AgentDownloadUtils> agentVersion2utils = new ConcurrentHashMap();
    private final String agentVersion;
    private Path agentDir;

    public static AgentDownloadUtils of(String agentVersion) {
        agentVersion2utils.putIfAbsent(agentVersion, new AgentDownloadUtils(agentVersion));
        return agentVersion2utils.get(agentVersion);
    }

    private AgentDownloadUtils(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public synchronized Path getTargetAgentDir() throws IOException {
        if (this.agentDir != null) {
            return this.agentDir;
        }
        URL jarLocation = AgentDownloadUtils.class.getProtectionDomain().getCodeSource().getLocation();
        Path attacherCliDir = Paths.get(jarLocation.getPath(), new String[0]).getParent();
        Path agentBaseDir = Files.isWritable(attacherCliDir) ? this.verifyReadableWritableDirExists(attacherCliDir, AGENT_BASE_DIR) : Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), AGENT_BASE_DIR, new FileAttribute[0]);
        String agentVersionDirName = this.agentVersion.replace('.', '_');
        this.agentDir = this.verifyReadableWritableDirExists(agentBaseDir, agentVersionDirName);
        return this.agentDir;
    }

    private Path verifyReadableWritableDirExists(Path parent, String childDirName) throws IOException {
        Path childDirPath = parent.resolve(childDirName);
        boolean createChildDir = true;
        if (Files.exists(childDirPath, new LinkOption[0])) {
            if (Files.isReadable(childDirPath) && Files.isWritable(childDirPath)) {
                createChildDir = false;
            } else {
                childDirPath = parent.resolve(UserRegistry.getCurrentUserName()).resolve(childDirName);
                boolean bl = createChildDir = !Files.exists(childDirPath, new LinkOption[0]);
            }
        }
        if (createChildDir) {
            Files.createDirectories(childDirPath, new FileAttribute[0]);
        }
        return childDirPath;
    }

    public Path getTargetLibDir() throws IOException {
        Path targetLibDir = this.getTargetAgentDir().resolve("lib");
        if (!Files.exists(targetLibDir, new LinkOption[0])) {
            Files.createDirectory(targetLibDir, new FileAttribute[0]);
        }
        return targetLibDir;
    }
}

