/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.AgentAttacher;
import co.elastic.apm.attach.ElasticAttachmentProvider;
import co.elastic.apm.attach.JvmInfo;
import co.elastic.apm.attach.UserRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import net.bytebuddy.agent.ByteBuddyAgent;

public class GetAgentProperties {
    public static void main(String[] args) throws Exception {
        GetAgentProperties.getAgentAndSystemPropertiesCurrentUser(args[0]).store(System.out, null);
    }

    public static Properties getAgentAndSystemProperties(String pid, UserRegistry.User user) throws Exception {
        if (user.isCurrentUser()) {
            return GetAgentProperties.getAgentAndSystemPropertiesCurrentUser(pid);
        }
        return GetAgentProperties.getAgentAndSystemPropertiesSwitchUser(pid, user);
    }

    static Properties getAgentAndSystemPropertiesSwitchUser(String pid, UserRegistry.User user) throws IOException, InterruptedException {
        Process process = user.runAsUserWithCurrentClassPath(GetAgentProperties.class, Arrays.asList(pid, user.getUsername())).start();
        if (process.waitFor() == 0) {
            Properties properties = new Properties();
            properties.load(process.getInputStream());
            return properties;
        }
        throw new RuntimeException(AgentAttacher.toString(process.getErrorStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getAgentAndSystemPropertiesCurrentUser(String pid) {
        Properties properties;
        ByteBuddyAgent.AttachmentProvider.Accessor accessor = ElasticAttachmentProvider.get().attempt();
        if (!accessor.isAvailable()) {
            throw new IllegalStateException("No compatible attachment provider is available");
        }
        if (accessor.isExternalAttachmentRequired() && pid.equals(JvmInfo.CURRENT_PID)) {
            throw new IllegalStateException("The current accessor does not allow to attach to the current VM");
        }
        Class<?> vm = accessor.getVirtualMachineType();
        Object virtualMachineInstance = vm.getMethod("attach", String.class).invoke(null, pid);
        try {
            Properties agentProperties = (Properties)vm.getMethod("getAgentProperties", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
            Properties systemProperties = (Properties)vm.getMethod("getSystemProperties", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
            systemProperties.putAll((Map<?, ?>)agentProperties);
            properties = systemProperties;
        }
        catch (Throwable throwable) {
            try {
                vm.getMethod("detach", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
                throw throwable;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error during attachment using: " + accessor, exception);
            }
        }
        vm.getMethod("detach", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
        return properties;
    }
}

