/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.testing;

import co.decodable.sdk.pipeline.EnvironmentAccess;
import co.decodable.sdk.pipeline.util.Incubating;
import co.decodable.sdk.pipeline.util.Unmodifiable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Incubating
public class TestEnvironment
implements EnvironmentAccess.Environment {
    private static final String STREAM_CONFIG_TEMPLATE = "{\n    \"properties\": {\n        \"value.format\": \"debezium-json\",\n        \"key.format\": \"json\",\n        \"topic\": \"%s\",\n        \"scan.startup.mode\": \"earliest-offset\",\n        \"key.fields\": \"\\\"order_id\\\"\",\n        \"sink.transactional-id-prefix\": \"tx-account-00000000-PIPELINE-af78c091-1686579235527\",\n        \"sink.delivery-guarantee\": \"exactly-once\",\n        \"properties.bootstrap.servers\": \"%s\",\n        \"properties.transaction.timeout.ms\": \"900000\",\n        \"properties.isolation.level\": \"read_committed\",\n        \"properties.compression.type\": \"zstd\",\n        \"properties.enable.idempotence\": \"true\"\n    },\n    \"name\": \"%s\"\n}";
    @Unmodifiable
    private final Map<String, StreamConfiguration> streams;
    private final String bootstrapServers;

    private TestEnvironment(String bootstrapServers, Map<String, StreamConfiguration> streams) {
        this.bootstrapServers = bootstrapServers;
        this.streams = Collections.unmodifiableMap(streams);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Map<String, String> getEnvironmentConfiguration() {
        return this.streams.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> "DECODABLE_STREAM_CONFIG_" + ((StreamConfiguration)e.getValue()).id(), e -> String.format(STREAM_CONFIG_TEMPLATE, ((StreamConfiguration)e.getValue()).topic(), this.bootstrapServers, ((StreamConfiguration)e.getValue()).name())));
    }

    public String topicFor(String streamName) {
        StreamConfiguration config = this.streams.get(streamName);
        if (config == null) {
            throw new IllegalArgumentException("Stream '" + streamName + "' has not been configured");
        }
        return config.topic();
    }

    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    private static class StreamConfiguration {
        private final String name;
        private final String id;
        private final String topic;

        public StreamConfiguration(String name) {
            this.name = name;
            this.id = StreamConfiguration.getRandomId();
            this.topic = "stream-00000000-" + this.id;
        }

        private static String getRandomId() {
            int digits = 8;
            return String.format("%0" + digits + "x", new BigInteger(digits * 4, new SecureRandom()));
        }

        public String name() {
            return this.name;
        }

        public String id() {
            return this.id;
        }

        public String topic() {
            return this.topic;
        }
    }

    public static class Builder {
        private String bootstrapServers;
        private final Map<String, StreamConfiguration> streams = new HashMap<String, StreamConfiguration>();

        public Builder withBootstrapServers(String bootstrapServers) {
            Objects.requireNonNull(bootstrapServers, "Bootstrap servers must be specified");
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public Builder withStreams(String firstStream, String ... furtherStreams) {
            Objects.requireNonNull(firstStream, "At least one stream name must be specified");
            this.streams.put(firstStream, new StreamConfiguration(firstStream));
            if (furtherStreams != null) {
                for (String stream : furtherStreams) {
                    this.streams.put(stream, new StreamConfiguration(stream));
                }
            }
            return this;
        }

        public TestEnvironment build() {
            return new TestEnvironment(this.bootstrapServers, this.streams);
        }
    }
}

