/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.internal;

import co.decodable.sdk.pipeline.DecodableSourceEnumeratorState;
import co.decodable.sdk.pipeline.DecodableSourceSplit;
import co.decodable.sdk.pipeline.internal.DecodableSourceEnumeratorStateImpl;
import co.decodable.sdk.pipeline.internal.DecodableSourceSplitImpl;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.connector.kafka.source.enumerator.KafkaSourceEnumState;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplit;

public class DelegatingSplitEnumerator
implements SplitEnumerator<DecodableSourceSplit, DecodableSourceEnumeratorState> {
    private final SplitEnumerator<KafkaPartitionSplit, KafkaSourceEnumState> delegate;

    public DelegatingSplitEnumerator(SplitEnumerator<KafkaPartitionSplit, KafkaSourceEnumState> delegate) {
        this.delegate = delegate;
    }

    public void start() {
        this.delegate.start();
    }

    public void handleSplitRequest(int subtaskId, String requesterHostname) {
        this.delegate.handleSplitRequest(subtaskId, requesterHostname);
    }

    public void addSplitsBack(List<DecodableSourceSplit> splits, int subtaskId) {
        List delegateSplits = splits.stream().map(s -> ((DecodableSourceSplitImpl)s).getDelegate()).collect(Collectors.toList());
        this.delegate.addSplitsBack(delegateSplits, subtaskId);
    }

    public void addReader(int subtaskId) {
        this.delegate.addReader(subtaskId);
    }

    public DecodableSourceEnumeratorState snapshotState(long checkpointId) throws Exception {
        return new DecodableSourceEnumeratorStateImpl((KafkaSourceEnumState)this.delegate.snapshotState(checkpointId));
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

