/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.internal;

import co.decodable.sdk.pipeline.DecodableSourceSplit;
import co.decodable.sdk.pipeline.internal.DecodableSourceSplitImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.source.ReaderInfo;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplit;
import org.apache.flink.metrics.groups.SplitEnumeratorMetricGroup;

public class DelegatingSplitEnumeratorContext
implements SplitEnumeratorContext<KafkaPartitionSplit> {
    private final SplitEnumeratorContext<DecodableSourceSplit> delegate;

    public DelegatingSplitEnumeratorContext(SplitEnumeratorContext<DecodableSourceSplit> delegate) {
        this.delegate = delegate;
    }

    public SplitEnumeratorMetricGroup metricGroup() {
        return this.delegate.metricGroup();
    }

    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
        this.delegate.sendEventToSourceReader(subtaskId, event);
    }

    public int currentParallelism() {
        return this.delegate.currentParallelism();
    }

    public Map<Integer, ReaderInfo> registeredReaders() {
        return this.delegate.registeredReaders();
    }

    public void assignSplits(SplitsAssignment<KafkaPartitionSplit> newSplitAssignments) {
        Map<Integer, List> delegateAssignments = newSplitAssignments.assignment().entrySet().stream().collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> ((List)e.getValue()).stream().map(DecodableSourceSplitImpl::new).collect(Collectors.toList())));
        this.delegate.assignSplits(new SplitsAssignment(delegateAssignments));
    }

    public void signalNoMoreSplits(int subtask) {
        this.delegate.signalNoMoreSplits(subtask);
    }

    public <T> void callAsync(Callable<T> callable, BiConsumer<T, Throwable> handler) {
        this.delegate.callAsync(callable, handler);
    }

    public <T> void callAsync(Callable<T> callable, BiConsumer<T, Throwable> handler, long initialDelayMillis, long periodMillis) {
        this.delegate.callAsync(callable, handler, initialDelayMillis, periodMillis);
    }

    public void runInCoordinatorThread(Runnable runnable) {
        this.delegate.runInCoordinatorThread(runnable);
    }
}

