/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase96.coprocessor;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionCodec;
import co.cask.tephra.TxConstants;
import co.cask.tephra.coprocessor.TransactionStateCache;
import co.cask.tephra.coprocessor.TransactionStateCacheSupplier;
import co.cask.tephra.hbase96.coprocessor.TransactionVisibilityFilter;
import co.cask.tephra.persist.TransactionVisibilityState;
import co.cask.tephra.util.TxUtils;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;

public class TransactionProcessor
extends BaseRegionObserver {
    private static final Log LOG = LogFactory.getLog(TransactionProcessor.class);
    private TransactionStateCache cache;
    private final TransactionCodec txCodec;
    protected Map<byte[], Long> ttlByFamily = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
    protected boolean allowEmptyValues = false;
    protected boolean readNonTxnData = false;

    public TransactionProcessor() {
        this.txCodec = new TransactionCodec();
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        if (e instanceof RegionCoprocessorEnvironment) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
            Supplier<TransactionStateCache> cacheSupplier = this.getTransactionStateCacheSupplier(env);
            this.cache = (TransactionStateCache)cacheSupplier.get();
            HTableDescriptor tableDesc = env.getRegion().getTableDesc();
            for (HColumnDescriptor columnDesc : tableDesc.getFamilies()) {
                String columnTTL = columnDesc.getValue("dataset.table.ttl");
                long ttl = 0L;
                if (columnTTL != null) {
                    try {
                        ttl = Long.parseLong(columnTTL);
                        LOG.info((Object)("Family " + columnDesc.getNameAsString() + " has TTL of " + columnTTL));
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn((Object)("Invalid TTL value configured for column family " + columnDesc.getNameAsString() + ", value = " + columnTTL));
                    }
                }
                this.ttlByFamily.put(columnDesc.getName(), ttl);
            }
            this.allowEmptyValues = env.getConfiguration().getBoolean("data.tx.allow.empty.values", false);
            this.readNonTxnData = Boolean.valueOf(tableDesc.getValue("data.tx.read.pre.existing"));
            if (this.readNonTxnData) {
                LOG.info((Object)("Reading pre-existing data enabled for table " + tableDesc.getNameAsString()));
            }
        }
    }

    protected Supplier<TransactionStateCache> getTransactionStateCacheSupplier(RegionCoprocessorEnvironment env) {
        return new TransactionStateCacheSupplier(env.getConfiguration());
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        Transaction tx = this.getFromOperation((OperationWithAttributes)get);
        if (tx != null) {
            this.projectFamilyDeletes(get);
            get.setMaxVersions();
            get.setTimeRange(TxUtils.getOldestVisibleTimestamp(this.ttlByFamily, (Transaction)tx, (boolean)this.readNonTxnData), TxUtils.getMaxVisibleTimestamp((Transaction)tx));
            Filter newFilter = this.getTransactionFilter(tx, ScanType.USER_SCAN, get.getFilter());
            get.setFilter(newFilter);
        }
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (delete.getAttribute("cask.tx.rollback") != null) {
            return;
        }
        Put deleteMarkers = new Put(delete.getRow(), delete.getTimeStamp());
        for (byte[] byArray : delete.getFamilyCellMap().keySet()) {
            List familyCells = (List)delete.getFamilyCellMap().get(byArray);
            if (this.isFamilyDelete(familyCells)) {
                deleteMarkers.add(byArray, TxConstants.FAMILY_DELETE_QUALIFIER, ((Cell)familyCells.get(0)).getTimestamp(), HConstants.EMPTY_BYTE_ARRAY);
                continue;
            }
            int cellSize = familyCells.size();
            for (int i = 0; i < cellSize; ++i) {
                Cell cell = (Cell)familyCells.get(i);
                deleteMarkers.add(byArray, CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), HConstants.EMPTY_BYTE_ARRAY);
            }
        }
        for (Map.Entry entry : delete.getAttributesMap().entrySet()) {
            deleteMarkers.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().put(deleteMarkers);
        e.bypass();
    }

    private boolean isFamilyDelete(List<Cell> familyCells) {
        return familyCells.size() == 1 && CellUtil.isDeleteFamily((Cell)familyCells.get(0));
    }

    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        Transaction tx = this.getFromOperation((OperationWithAttributes)scan);
        if (tx != null) {
            this.projectFamilyDeletes(scan);
            scan.setMaxVersions();
            scan.setTimeRange(TxUtils.getOldestVisibleTimestamp(this.ttlByFamily, (Transaction)tx, (boolean)this.readNonTxnData), TxUtils.getMaxVisibleTimestamp((Transaction)tx));
            Filter newFilter = this.getTransactionFilter(tx, ScanType.USER_SCAN, scan.getFilter());
            scan.setFilter(newFilter);
        }
        return s;
    }

    private Scan projectFamilyDeletes(Scan scan) {
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            NavigableSet columns = (NavigableSet)entry.getValue();
            if (columns == null || columns.isEmpty()) continue;
            scan.addColumn((byte[])entry.getKey(), TxConstants.FAMILY_DELETE_QUALIFIER);
        }
        return scan;
    }

    private Get projectFamilyDeletes(Get get) {
        for (Map.Entry entry : get.getFamilyMap().entrySet()) {
            NavigableSet columns = (NavigableSet)entry.getValue();
            if (columns == null || columns.isEmpty()) continue;
            get.addColumn((byte[])entry.getKey(), TxConstants.FAMILY_DELETE_QUALIFIER);
        }
        return get;
    }

    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner scanner) throws IOException {
        return this.createStoreScanner((RegionCoprocessorEnvironment)c.getEnvironment(), "flush", this.cache.getLatestState(), store, Collections.singletonList(memstoreScanner), ScanType.COMPACT_RETAIN_DELETES, Long.MIN_VALUE);
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s, CompactionRequest request) throws IOException {
        return this.createStoreScanner((RegionCoprocessorEnvironment)c.getEnvironment(), "compaction", this.cache.getLatestState(), store, scanners, scanType, earliestPutTs);
    }

    protected InternalScanner createStoreScanner(RegionCoprocessorEnvironment env, String action, TransactionVisibilityState snapshot, Store store, List<? extends KeyValueScanner> scanners, ScanType type, long earliestPutTs) throws IOException {
        if (snapshot == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Region " + env.getRegion().getRegionNameAsString() + ", no current transaction state found, defaulting to normal " + action + " scanner"));
            }
            return null;
        }
        Transaction dummyTx = TxUtils.createDummyTransaction((TransactionVisibilityState)snapshot);
        Scan scan = new Scan();
        scan.setMaxVersions();
        scan.setFilter((Filter)new IncludeInProgressFilter(dummyTx.getVisibilityUpperBound(), snapshot.getInvalid(), this.getTransactionFilter(dummyTx, type, null)));
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, type, store.getSmallestReadPoint(), earliestPutTs);
    }

    private Transaction getFromOperation(OperationWithAttributes op) throws IOException {
        byte[] encoded = op.getAttribute("cask.tx");
        if (encoded != null) {
            return this.txCodec.decode(encoded);
        }
        return null;
    }

    protected Filter getTransactionFilter(Transaction tx, ScanType type, Filter filter) {
        return new TransactionVisibilityFilter(tx, this.ttlByFamily, this.allowEmptyValues, type, filter);
    }

    static class IncludeInProgressFilter
    extends FilterBase {
        private final long visibilityUpperBound;
        private final Set<Long> invalidIds;
        private final Filter txFilter;

        public IncludeInProgressFilter(long upperBound, Collection<Long> invalids, Filter transactionFilter) {
            this.visibilityUpperBound = upperBound;
            this.invalidIds = Sets.newHashSet(invalids);
            this.txFilter = transactionFilter;
        }

        public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
            long ts = cell.getTimestamp();
            if (ts > this.visibilityUpperBound) {
                if (this.invalidIds.contains(ts)) {
                    return Filter.ReturnCode.SKIP;
                }
                return Filter.ReturnCode.INCLUDE;
            }
            return this.txFilter.filterKeyValue(cell);
        }
    }
}

