/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase96.coprocessor;

import co.cask.tephra.Transaction;
import co.cask.tephra.TxConstants;
import co.cask.tephra.util.TxUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.util.Bytes;

public class TransactionVisibilityFilter
extends FilterBase {
    private final Transaction tx;
    private final Map<byte[], Long> oldestTsByFamily;
    private final boolean allowEmptyValues;
    private final boolean clearDeletes;
    private final Filter cellFilter;
    private byte[] currentFamily = new byte[0];
    private long currentOldestTs;
    private DeleteTracker deleteTracker = new DeleteTracker();

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues, ScanType scanType) {
        this(tx, ttlByFamily, allowEmptyValues, scanType, null);
    }

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues, ScanType scanType, @Nullable Filter cellFilter) {
        this.tx = tx;
        this.oldestTsByFamily = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], Long> ttlEntry : ttlByFamily.entrySet()) {
            long familyTTL = ttlEntry.getValue();
            this.oldestTsByFamily.put(ttlEntry.getKey(), familyTTL <= 0L ? 0L : tx.getVisibilityUpperBound() - familyTTL * 1000000L);
        }
        this.allowEmptyValues = allowEmptyValues;
        this.clearDeletes = scanType == ScanType.COMPACT_DROP_DELETES || scanType == ScanType.USER_SCAN && tx.getVisibilityLevel() != Transaction.VisibilityLevel.SNAPSHOT_ALL;
        this.cellFilter = cellFilter;
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        long kvTimestamp;
        if (!CellUtil.matchingFamily((Cell)cell, (byte[])this.currentFamily)) {
            this.currentFamily = CellUtil.cloneFamily((Cell)cell);
            Long familyOldestTs = this.oldestTsByFamily.get(this.currentFamily);
            this.currentOldestTs = familyOldestTs != null ? familyOldestTs : 0L;
            this.deleteTracker.reset();
        }
        if (TxUtils.getTimestampForTTL((long)(kvTimestamp = cell.getTimestamp())) < this.currentOldestTs) {
            return Filter.ReturnCode.NEXT_COL;
        }
        if (this.tx.isVisible(kvTimestamp)) {
            if (this.tx.getVisibilityLevel() == Transaction.VisibilityLevel.SNAPSHOT_ALL && this.tx.isCurrentWrite(kvTimestamp)) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (DeleteTracker.isFamilyDelete(cell)) {
                this.deleteTracker.addFamilyDelete(cell);
                if (this.clearDeletes) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
            if (this.deleteTracker.isDeleted(cell)) {
                return Filter.ReturnCode.NEXT_COL;
            }
            if (this.isColumnDelete(cell)) {
                if (this.clearDeletes) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
            if (this.cellFilter != null) {
                return this.cellFilter.filterKeyValue(cell);
            }
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        return Filter.ReturnCode.SKIP;
    }

    public Cell transformCell(Cell cell) throws IOException {
        if (this.tx.getVisibilityLevel() == Transaction.VisibilityLevel.SNAPSHOT_ALL) {
            if (DeleteTracker.isFamilyDelete(cell)) {
                return new KeyValue(CellUtil.cloneRow((Cell)cell), CellUtil.cloneFamily((Cell)cell), null, cell.getTimestamp(), KeyValue.Type.DeleteFamily);
            }
            if (this.isColumnDelete(cell)) {
                return new KeyValue(CellUtil.cloneRow((Cell)cell), CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), KeyValue.Type.DeleteColumn);
            }
        }
        return cell;
    }

    public void reset() {
        this.deleteTracker.reset();
    }

    public byte[] toByteArray() throws IOException {
        return super.toByteArray();
    }

    private boolean isColumnDelete(Cell cell) {
        return !TxUtils.isPreExistingVersion((long)cell.getTimestamp()) && cell.getValueLength() == 0 && !this.allowEmptyValues;
    }

    private static final class DeleteTracker {
        private long familyDeleteTs;

        private DeleteTracker() {
        }

        public static boolean isFamilyDelete(Cell cell) {
            return !TxUtils.isPreExistingVersion((long)cell.getTimestamp()) && CellUtil.matchingQualifier((Cell)cell, (byte[])TxConstants.FAMILY_DELETE_QUALIFIER) && CellUtil.matchingValue((Cell)cell, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        }

        public void addFamilyDelete(Cell delete) {
            this.familyDeleteTs = delete.getTimestamp();
        }

        public boolean isDeleted(Cell cell) {
            return cell.getTimestamp() <= this.familyDeleteTs;
        }

        public void reset() {
            this.familyDeleteTs = 0L;
        }
    }
}

