/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase96.coprocessor;

import co.cask.tephra.Transaction;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;

public class TransactionVisibilityFilter
extends FilterBase {
    private final Transaction tx;
    private final Map<byte[], Long> oldestTsByFamily;
    private final boolean allowEmptyValues;
    private final Filter cellFilter;
    private byte[] currentFamily = new byte[0];
    private long currentOldestTs;

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues) {
        this(tx, ttlByFamily, allowEmptyValues, null);
    }

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues, @Nullable Filter cellFilter) {
        this.tx = tx;
        this.oldestTsByFamily = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], Long> ttlEntry : ttlByFamily.entrySet()) {
            long familyTTL = ttlEntry.getValue();
            this.oldestTsByFamily.put(ttlEntry.getKey(), familyTTL <= 0L ? 0L : tx.getVisibilityUpperBound() - familyTTL * 1000000L);
        }
        this.allowEmptyValues = allowEmptyValues;
        this.cellFilter = cellFilter;
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        long kvTimestamp;
        if (!CellUtil.matchingFamily((Cell)cell, (byte[])this.currentFamily)) {
            this.currentFamily = CellUtil.cloneFamily((Cell)cell);
            Long familyOldestTs = this.oldestTsByFamily.get(this.currentFamily);
            long l = this.currentOldestTs = familyOldestTs != null ? familyOldestTs : 0L;
        }
        if ((kvTimestamp = cell.getTimestamp()) < this.currentOldestTs) {
            return Filter.ReturnCode.NEXT_COL;
        }
        if (this.tx.isVisible(kvTimestamp)) {
            if (cell.getValueLength() == 0 && !this.allowEmptyValues) {
                return Filter.ReturnCode.NEXT_COL;
            }
            if (this.cellFilter != null) {
                return this.cellFilter.filterKeyValue(cell);
            }
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        return Filter.ReturnCode.SKIP;
    }

    public byte[] toByteArray() throws IOException {
        return super.toByteArray();
    }
}

