/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase96;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionCodec;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAwareHTable
implements HTableInterface,
TransactionAware {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionAwareHTable.class);
    private Transaction tx;
    private final HTable hTable;
    private final TransactionCodec txCodec;
    private final List<ActionChange> changeSet;
    private boolean allowNonTransactional;

    public TransactionAwareHTable(HTable hTable) {
        this(hTable, false);
    }

    public TransactionAwareHTable(HTable hTable, boolean allowNonTransactional) {
        this.hTable = hTable;
        this.changeSet = new ArrayList<ActionChange>();
        this.txCodec = new TransactionCodec();
        this.allowNonTransactional = allowNonTransactional;
    }

    public boolean getAllowNonTransactional() {
        return this.allowNonTransactional;
    }

    public void setAllowNonTransactional(boolean allowNonTransactional) {
        this.allowNonTransactional = allowNonTransactional;
    }

    public byte[] getTableName() {
        return this.hTable.getTableName();
    }

    public TableName getName() {
        return this.hTable.getName();
    }

    public Configuration getConfiguration() {
        return this.hTable.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.hTable.getTableDescriptor();
    }

    public boolean exists(Get get) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.exists(this.transactionalizeAction(get));
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>(gets.size());
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.exists(transactionalizedGets);
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.batch(this.transactionalizeActions(actions), results);
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.batch(this.transactionalizeActions(actions));
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.batchCallback(this.transactionalizeActions(actions), results, callback);
    }

    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.batchCallback(this.transactionalizeActions(actions), callback);
    }

    public Result get(Get get) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.get(this.transactionalizeAction(get));
    }

    public Result[] get(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>();
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.get(transactionalizedGets);
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.getRowOrBefore(row, family);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public void put(Put put) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Put txPut = this.transactionalizeAction(put);
        this.hTable.put(txPut);
    }

    public void put(List<Put> puts) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Put> transactionalizedPuts = new ArrayList<Put>(puts.size());
        for (Put put : puts) {
            Put txPut = this.transactionalizeAction(put);
            transactionalizedPuts.add(txPut);
        }
        this.hTable.put(transactionalizedPuts);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndPut(row, family, qualifier, value, put);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public void delete(Delete delete) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.put(this.transactionalizeAction(delete));
    }

    public void delete(List<Delete> deletes) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Put> transactionalizedPuts = new ArrayList<Put>(deletes.size());
        for (Delete delete : deletes) {
            Put txPut = this.transactionalizeAction(delete);
            transactionalizedPuts.add(txPut);
        }
        this.hTable.put(transactionalizedPuts);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndDelete(row, family, qualifier, value, delete);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public void mutateRow(RowMutations rm) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        RowMutations transactionalMutations = new RowMutations();
        for (Mutation mutation : rm.getMutations()) {
            if (mutation instanceof Put) {
                transactionalMutations.add(this.transactionalizeAction((Put)mutation));
                continue;
            }
            if (!(mutation instanceof Delete)) continue;
            transactionalMutations.add(this.transactionalizeAction((Delete)mutation));
        }
        this.hTable.mutateRow(transactionalMutations);
    }

    public Result append(Append append) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.append(append);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public Result increment(Increment increment) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.increment(increment);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount, durability);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean isAutoFlush() {
        return this.hTable.isAutoFlush();
    }

    public void flushCommits() throws IOException {
        this.hTable.flushCommits();
    }

    public void close() throws IOException {
        this.hTable.close();
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.hTable.coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.hTable.coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.hTable.coprocessorService(service, startKey, endKey, callable, callback);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.setAutoFlushTo(autoFlush);
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.hTable.setAutoFlush(autoFlush, clearBufferOnFail);
    }

    public void setAutoFlushTo(boolean autoFlush) {
        this.hTable.setAutoFlushTo(autoFlush);
    }

    public long getWriteBufferSize() {
        return this.hTable.getWriteBufferSize();
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.hTable.setWriteBufferSize(writeBufferSize);
    }

    public void startTx(Transaction tx) {
        this.tx = tx;
    }

    public Collection<byte[]> getTxChanges() {
        ArrayList<byte[]> txChanges = new ArrayList<byte[]>();
        for (ActionChange change : this.changeSet) {
            txChanges.add(Bytes.add((byte[])this.getTableName(), (byte[])change.getRow(), (byte[])Bytes.add((byte[])change.getFamily(), (byte[])change.getQualifier())));
        }
        return txChanges;
    }

    public boolean commitTx() throws Exception {
        this.hTable.flushCommits();
        return true;
    }

    public void postTxCommit() {
        this.tx = null;
        this.changeSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollbackTx() throws Exception {
        try {
            ArrayList<Delete> rollbackDeletes = new ArrayList<Delete>(this.changeSet.size());
            for (ActionChange change : this.changeSet) {
                byte[] row = change.getRow();
                byte[] family = change.getFamily();
                byte[] qualifier = change.getQualifier();
                long transactionTimestamp = this.tx.getWritePointer();
                Delete rollbackDelete = new Delete(row, transactionTimestamp);
                if (family != null && qualifier == null) {
                    rollbackDelete.deleteFamily(family, transactionTimestamp);
                } else if (family != null && qualifier != null) {
                    rollbackDelete.deleteColumn(family, qualifier, transactionTimestamp);
                }
                rollbackDeletes.add(rollbackDelete);
            }
            this.hTable.delete(rollbackDeletes);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                this.hTable.flushCommits();
            }
            catch (Exception e) {
                LOG.error("Could not flush HTable commits", (Throwable)e);
            }
            this.tx = null;
            this.changeSet.clear();
        }
    }

    public String getTransactionAwareName() {
        return Bytes.toString((byte[])this.getTableName());
    }

    private Get transactionalizeAction(Get get) throws IOException {
        this.txCodec.addToOperation((OperationWithAttributes)get, this.tx);
        return get;
    }

    private Scan transactionalizeAction(Scan scan) throws IOException {
        this.txCodec.addToOperation((OperationWithAttributes)scan, this.tx);
        return scan;
    }

    private Put transactionalizeAction(Put put) throws IOException {
        Put txPut = new Put(put.getRow(), this.tx.getWritePointer());
        Set familyMap = put.getFamilyMap().entrySet();
        if (!familyMap.isEmpty()) {
            for (Map.Entry family : familyMap) {
                List familyValues = (List)family.getValue();
                if (familyValues.isEmpty()) continue;
                for (KeyValue value : familyValues) {
                    txPut.add(value.getFamily(), value.getQualifier(), this.tx.getWritePointer(), value.getValue());
                    this.changeSet.add(new ActionChange(txPut.getRow(), value.getFamily(), value.getQualifier()));
                }
            }
        }
        for (Map.Entry entry : put.getAttributesMap().entrySet()) {
            txPut.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        txPut.setWriteToWAL(put.getWriteToWAL());
        this.txCodec.addToOperation((OperationWithAttributes)txPut, this.tx);
        return txPut;
    }

    private Put transactionalizeAction(Delete delete) throws IOException {
        long transactionTimestamp = this.tx.getWritePointer();
        byte[] deleteRow = delete.getRow();
        Put txPut = new Put(deleteRow, transactionTimestamp);
        Map familyToDelete = delete.getFamilyMap();
        if (familyToDelete.isEmpty()) {
            Result result = this.get(new Get(delete.getRow()));
            NavigableMap resultMap = result.getNoVersionMap();
            for (Map.Entry familyEntry : resultMap.entrySet()) {
                NavigableMap familyColumns = result.getFamilyMap((byte[])familyEntry.getKey());
                for (Map.Entry column : familyColumns.entrySet()) {
                    txPut.add((byte[])familyEntry.getKey(), (byte[])column.getKey(), transactionTimestamp, new byte[0]);
                    this.changeSet.add(new ActionChange(deleteRow, (byte[])familyEntry.getKey(), (byte[])column.getKey()));
                }
            }
        } else {
            for (Map.Entry familyEntry : familyToDelete.entrySet()) {
                byte[] family = (byte[])familyEntry.getKey();
                List entries = (List)familyEntry.getValue();
                if (entries.isEmpty()) {
                    Result result = this.get(new Get(delete.getRow()));
                    NavigableMap familyColumns = result.getFamilyMap(family);
                    for (Map.Entry column : familyColumns.entrySet()) {
                        txPut.add(family, (byte[])column.getKey(), transactionTimestamp, new byte[0]);
                        this.changeSet.add(new ActionChange(deleteRow, family, (byte[])column.getKey()));
                    }
                    continue;
                }
                for (KeyValue value : entries) {
                    txPut.add(value.getFamily(), value.getQualifier(), transactionTimestamp, new byte[0]);
                    this.changeSet.add(new ActionChange(deleteRow, value.getFamily(), value.getQualifier()));
                }
            }
        }
        return txPut;
    }

    private List<? extends Row> transactionalizeActions(List<? extends Row> actions) throws IOException {
        ArrayList<Object> transactionalizedActions = new ArrayList<Object>(actions.size());
        for (Row row : actions) {
            if (row instanceof Get) {
                transactionalizedActions.add(this.transactionalizeAction((Get)row));
                continue;
            }
            if (row instanceof Put) {
                transactionalizedActions.add(this.transactionalizeAction((Put)row));
                continue;
            }
            if (row instanceof Delete) {
                transactionalizedActions.add(this.transactionalizeAction((Delete)row));
                continue;
            }
            transactionalizedActions.add(row);
        }
        return transactionalizedActions;
    }

    private class ActionChange {
        private final byte[] row;
        private final byte[] family;
        private final byte[] qualifier;

        private ActionChange(byte[] row, byte[] family, byte[] qualifier) {
            this.row = row;
            this.family = family;
            this.qualifier = qualifier;
        }

        private byte[] getRow() {
            return this.row;
        }

        private byte[] getFamily() {
            return this.family;
        }

        private byte[] getQualifier() {
            return this.qualifier;
        }
    }
}

