/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.examples;

import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionConflictException;
import co.cask.tephra.TransactionContext;
import co.cask.tephra.TransactionFailureException;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.distributed.TransactionServiceClient;
import co.cask.tephra.hbase10cdh.TransactionAwareHTable;
import co.cask.tephra.hbase10cdh.coprocessor.TransactionProcessor;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionClientModule;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.runtime.ZKModule;
import co.cask.tephra.util.ConfigurationFactory;
import com.google.common.io.Closeables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.twill.zookeeper.ZKClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceBooks
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BalanceBooks.class);
    private static final int MAX_AMOUNT = 100;
    private static final byte[] TABLE = Bytes.toBytes((String)"testbalances");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] COL = Bytes.toBytes((String)"b");
    private final int totalClients;
    private final int iterations;
    private Configuration conf;
    private ZKClientService zkClient;
    private TransactionServiceClient txClient;
    private HConnection conn;

    public BalanceBooks(int totalClients, int iterations) {
        this(totalClients, iterations, new ConfigurationFactory().get());
    }

    public BalanceBooks(int totalClients, int iterations, Configuration conf) {
        this.totalClients = totalClients;
        this.iterations = iterations;
        this.conf = conf;
    }

    public void init() throws IOException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(this.conf), new ZKModule(), new DiscoveryModules().getDistributedModules(), new TransactionModules().getDistributedModules(), new TransactionClientModule()});
        this.zkClient = (ZKClientService)injector.getInstance(ZKClientService.class);
        this.zkClient.startAndWait();
        this.txClient = (TransactionServiceClient)injector.getInstance(TransactionServiceClient.class);
        this.createTableIfNotExists(this.conf, TABLE, new byte[][]{FAMILY});
        this.conn = HConnectionManager.createConnection((Configuration)this.conf);
    }

    public void run() throws IOException, InterruptedException {
        ArrayList<Client> clients = new ArrayList<Client>(this.totalClients);
        for (int i = 0; i < this.totalClients; ++i) {
            Client c = new Client(i, this.totalClients, this.iterations);
            c.init((TransactionSystemClient)this.txClient, this.conn.getTable(TABLE));
            c.start();
            clients.add(c);
        }
        for (Client c : clients) {
            c.join();
            Closeables.closeQuietly((Closeable)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify() {
        boolean success = false;
        try {
            TransactionAwareHTable table = new TransactionAwareHTable(this.conn.getTable(TABLE));
            TransactionContext context = new TransactionContext((TransactionSystemClient)this.txClient, new TransactionAware[]{table});
            LOG.info("VERIFYING BALANCES");
            context.start();
            long totalBalance = 0L;
            ResultScanner scanner = table.getScanner(new Scan());
            try {
                for (Result r : scanner) {
                    if (r.isEmpty()) continue;
                    int rowId = Bytes.toInt((byte[])r.getRow());
                    long balance = Bytes.toLong((byte[])r.getValue(FAMILY, COL));
                    totalBalance += balance;
                    LOG.info("Client #{}: balance = ${}", (Object)rowId, (Object)balance);
                }
            }
            finally {
                if (scanner != null) {
                    Closeables.closeQuietly((Closeable)scanner);
                }
            }
            if (totalBalance == 0L) {
                LOG.info("PASSED!");
                success = true;
            } else {
                LOG.info("FAILED! Total balance should be 0 but was {}", (Object)totalBalance);
            }
            context.finish();
        }
        catch (Exception e) {
            LOG.error("Failed verification check", (Throwable)e);
        }
        return success;
    }

    @Override
    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.zkClient != null) {
            this.zkClient.stopAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTableIfNotExists(Configuration conf, byte[] tableName, byte[][] columnFamilies) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
            for (byte[] family : columnFamilies) {
                HColumnDescriptor columnDesc = new HColumnDescriptor(family);
                columnDesc.setMaxVersions(Integer.MAX_VALUE);
                desc.addFamily(columnDesc);
            }
            desc.addCoprocessor(TransactionProcessor.class.getName());
            admin.createTable(desc);
        }
        finally {
            if (admin != null) {
                try {
                    admin.close();
                }
                catch (IOException ioe) {
                    LOG.warn("Error closing HBaseAdmin", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java " + BalanceBooks.class.getName() + " <num clients> <iterations>");
            System.err.println("\twhere <num clients> >= 2");
            System.exit(1);
        }
        try (BalanceBooks bb = new BalanceBooks(Integer.parseInt(args[0]), Integer.parseInt(args[1]));){
            bb.init();
            bb.run();
            bb.verify();
        }
    }

    private static class Client
    extends Thread
    implements Closeable {
        private final int id;
        private final int totalClients;
        private final int iterations;
        private final Random random = new Random();
        private TransactionContext txContext;
        private TransactionAwareHTable txTable;

        public Client(int id, int totalClients, int iterations) {
            this.id = id;
            this.totalClients = totalClients;
            this.iterations = iterations;
        }

        public void init(TransactionSystemClient txClient, HTableInterface table) {
            this.txTable = new TransactionAwareHTable(table);
            this.txContext = new TransactionContext(txClient, new TransactionAware[]{this.txTable});
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.iterations; ++i) {
                    this.runOnce();
                }
            }
            catch (TransactionFailureException e) {
                LOG.error("Client #{}: Failed on exception", (Object)this.id, (Object)e);
            }
        }

        private void runOnce() throws TransactionFailureException {
            int withdrawee = this.getNextWithdrawee();
            int amount = this.getAmount();
            try {
                this.txContext.start();
                long withdraweeBalance = this.getCurrentBalance(withdrawee);
                long ownBalance = this.getCurrentBalance(this.id);
                long withdraweeNew = withdraweeBalance - (long)amount;
                long ownNew = ownBalance + (long)amount;
                this.setBalance(withdrawee, withdraweeNew);
                this.setBalance(this.id, ownNew);
                LOG.info("Client #{}: Withdrew ${} from #{}; withdrawee old={}, new={}; own old={}, new={}", new Object[]{this.id, amount, withdrawee, withdraweeBalance, withdraweeNew, ownBalance, ownNew});
                this.txContext.finish();
            }
            catch (IOException ioe) {
                LOG.error("Client #{}: Unhandled client failure", (Object)this.id, (Object)ioe);
                this.txContext.abort();
            }
            catch (TransactionConflictException tce) {
                LOG.info("CONFLICT: client #{} attempting to withdraw from #{}", (Object)this.id, (Object)withdrawee);
                this.txContext.abort((TransactionFailureException)((Object)tce));
            }
            catch (TransactionFailureException tfe) {
                LOG.error("Client #{}: Unhandled transaction failure", (Object)this.id, (Object)tfe);
                this.txContext.abort(tfe);
            }
        }

        private long getCurrentBalance(int id) throws IOException {
            Result r = this.txTable.get(new Get(Bytes.toBytes((int)id)));
            byte[] balanceBytes = r.getValue(FAMILY, COL);
            if (balanceBytes == null) {
                return 0L;
            }
            return Bytes.toLong((byte[])balanceBytes);
        }

        private void setBalance(int id, long balance) throws IOException {
            this.txTable.put(new Put(Bytes.toBytes((int)id)).add(FAMILY, COL, Bytes.toBytes((long)balance)));
        }

        private int getNextWithdrawee() {
            int next;
            while ((next = this.random.nextInt(this.totalClients)) == this.id) {
            }
            return next;
        }

        private int getAmount() {
            return this.random.nextInt(100);
        }

        @Override
        public void close() throws IOException {
            this.txTable.close();
        }
    }
}

