/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.util;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseVersion {
    private static final String HBASE_94_VERSION = "0.94";
    private static final String HBASE_96_VERSION = "0.96";
    private static final String HBASE_98_VERSION = "0.98";
    private static final Logger LOG = LoggerFactory.getLogger(HBaseVersion.class);
    private static Version currentVersion;
    private static String versionString;

    public static Version get() {
        return currentVersion;
    }

    public static String getVersionString() {
        return versionString;
    }

    public static void main(String[] args) {
        Version version = HBaseVersion.get();
        System.out.println(version.getMajorVersion());
    }

    static {
        try {
            Class<?> versionInfoClass = Class.forName("org.apache.hadoop.hbase.util.VersionInfo");
            Method versionMethod = versionInfoClass.getMethod("getVersion", new Class[0]);
            versionString = (String)versionMethod.invoke(null, new Object[0]);
            currentVersion = versionString.startsWith(HBASE_94_VERSION) ? Version.HBASE_94 : (versionString.startsWith(HBASE_96_VERSION) ? Version.HBASE_96 : (versionString.startsWith(HBASE_98_VERSION) ? Version.HBASE_98 : Version.UNKNOWN));
        }
        catch (Throwable e) {
            LOG.error("Unable to determine HBase version from string '{}', are HBase classes available?", (Object)versionString);
            LOG.error("Exception was: ", e);
            currentVersion = Version.UNKNOWN;
        }
    }

    public static enum Version {
        HBASE_94("0.94"),
        HBASE_96("0.96"),
        HBASE_98("0.98"),
        UNKNOWN("unknown");

        final String majorVersion;

        private Version(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        public String getMajorVersion() {
            return this.majorVersion;
        }
    }
}

